/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.NodeSelector;
import io.argoproj.workflow.models.PreferredSchedulingTerm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Node affinity is a group of node affinity scheduling rules.")
public class NodeAffinity {
    public static final String SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION = "preferredDuringSchedulingIgnoredDuringExecution";
    @SerializedName(value="preferredDuringSchedulingIgnoredDuringExecution")
    private List<PreferredSchedulingTerm> preferredDuringSchedulingIgnoredDuringExecution = null;
    public static final String SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION = "requiredDuringSchedulingIgnoredDuringExecution";
    @SerializedName(value="requiredDuringSchedulingIgnoredDuringExecution")
    private NodeSelector requiredDuringSchedulingIgnoredDuringExecution;

    public NodeAffinity preferredDuringSchedulingIgnoredDuringExecution(List<PreferredSchedulingTerm> preferredDuringSchedulingIgnoredDuringExecution) {
        this.preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution;
        return this;
    }

    public NodeAffinity addPreferredDuringSchedulingIgnoredDuringExecutionItem(PreferredSchedulingTerm preferredDuringSchedulingIgnoredDuringExecutionItem) {
        if (this.preferredDuringSchedulingIgnoredDuringExecution == null) {
            this.preferredDuringSchedulingIgnoredDuringExecution = new ArrayList<PreferredSchedulingTerm>();
        }
        this.preferredDuringSchedulingIgnoredDuringExecution.add(preferredDuringSchedulingIgnoredDuringExecutionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.")
    public List<PreferredSchedulingTerm> getPreferredDuringSchedulingIgnoredDuringExecution() {
        return this.preferredDuringSchedulingIgnoredDuringExecution;
    }

    public void setPreferredDuringSchedulingIgnoredDuringExecution(List<PreferredSchedulingTerm> preferredDuringSchedulingIgnoredDuringExecution) {
        this.preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution;
    }

    public NodeAffinity requiredDuringSchedulingIgnoredDuringExecution(NodeSelector requiredDuringSchedulingIgnoredDuringExecution) {
        this.requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NodeSelector getRequiredDuringSchedulingIgnoredDuringExecution() {
        return this.requiredDuringSchedulingIgnoredDuringExecution;
    }

    public void setRequiredDuringSchedulingIgnoredDuringExecution(NodeSelector requiredDuringSchedulingIgnoredDuringExecution) {
        this.requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeAffinity nodeAffinity = (NodeAffinity)o;
        return Objects.equals(this.preferredDuringSchedulingIgnoredDuringExecution, nodeAffinity.preferredDuringSchedulingIgnoredDuringExecution) && Objects.equals(this.requiredDuringSchedulingIgnoredDuringExecution, nodeAffinity.requiredDuringSchedulingIgnoredDuringExecution);
    }

    public int hashCode() {
        return Objects.hash(this.preferredDuringSchedulingIgnoredDuringExecution, this.requiredDuringSchedulingIgnoredDuringExecution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodeAffinity {\n");
        sb.append("    preferredDuringSchedulingIgnoredDuringExecution: ").append(this.toIndentedString(this.preferredDuringSchedulingIgnoredDuringExecution)).append("\n");
        sb.append("    requiredDuringSchedulingIgnoredDuringExecution: ").append(this.toIndentedString(this.requiredDuringSchedulingIgnoredDuringExecution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

