/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.")
public class ManagedFieldsEntry {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_FIELDS_TYPE = "fieldsType";
    @SerializedName(value="fieldsType")
    private String fieldsType;
    public static final String SERIALIZED_NAME_FIELDS_V1 = "fieldsV1";
    @SerializedName(value="fieldsV1")
    private Object fieldsV1;
    public static final String SERIALIZED_NAME_MANAGER = "manager";
    @SerializedName(value="manager")
    private String manager;
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    private String operation;
    public static final String SERIALIZED_NAME_SUBRESOURCE = "subresource";
    @SerializedName(value="subresource")
    private String subresource;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private Instant time;

    public ManagedFieldsEntry apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the version of this resource that this field set applies to. The format is \"group/version\" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ManagedFieldsEntry fieldsType(String fieldsType) {
        this.fieldsType = fieldsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: \"FieldsV1\"")
    public String getFieldsType() {
        return this.fieldsType;
    }

    public void setFieldsType(String fieldsType) {
        this.fieldsType = fieldsType;
    }

    public ManagedFieldsEntry fieldsV1(Object fieldsV1) {
        this.fieldsV1 = fieldsV1;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FieldsV1 stores a set of fields in a data structure like a Trie, in JSON format.  Each key is either a '.' representing the field itself, and will always map to an empty set, or a string representing a sub-field or item. The string will follow one of these four formats: 'f:<name>', where <name> is the name of a field in a struct, or key in a map 'v:<value>', where <value> is the exact json formatted value of a list item 'i:<index>', where <index> is position of a item in a list 'k:<keys>', where <keys> is a map of  a list item's key fields to their unique values If a key maps to an empty Fields value, the field that key represents is part of the set.  The exact format is defined in sigs.k8s.io/structured-merge-diff")
    public Object getFieldsV1() {
        return this.fieldsV1;
    }

    public void setFieldsV1(Object fieldsV1) {
        this.fieldsV1 = fieldsV1;
    }

    public ManagedFieldsEntry manager(String manager) {
        this.manager = manager;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Manager is an identifier of the workflow managing these fields.")
    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public ManagedFieldsEntry operation(String operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public ManagedFieldsEntry subresource(String subresource) {
        this.subresource = subresource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Subresource is the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource.")
    public String getSubresource() {
        return this.subresource;
    }

    public void setSubresource(String subresource) {
        this.subresource = subresource;
    }

    public ManagedFieldsEntry time(Instant time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedFieldsEntry managedFieldsEntry = (ManagedFieldsEntry)o;
        return Objects.equals(this.apiVersion, managedFieldsEntry.apiVersion) && Objects.equals(this.fieldsType, managedFieldsEntry.fieldsType) && Objects.equals(this.fieldsV1, managedFieldsEntry.fieldsV1) && Objects.equals(this.manager, managedFieldsEntry.manager) && Objects.equals(this.operation, managedFieldsEntry.operation) && Objects.equals(this.subresource, managedFieldsEntry.subresource) && Objects.equals(this.time, managedFieldsEntry.time);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldsType, this.fieldsV1, this.manager, this.operation, this.subresource, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManagedFieldsEntry {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    fieldsType: ").append(this.toIndentedString(this.fieldsType)).append("\n");
        sb.append("    fieldsV1: ").append(this.toIndentedString(this.fieldsV1)).append("\n");
        sb.append("    manager: ").append(this.toIndentedString(this.manager)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    subresource: ").append(this.toIndentedString(this.subresource)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

