/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.LabelSelectorRequirement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.")
public class LabelSelector {
    public static final String SERIALIZED_NAME_MATCH_EXPRESSIONS = "matchExpressions";
    @SerializedName(value="matchExpressions")
    private List<LabelSelectorRequirement> matchExpressions = null;
    public static final String SERIALIZED_NAME_MATCH_LABELS = "matchLabels";
    @SerializedName(value="matchLabels")
    private Map<String, String> matchLabels = null;

    public LabelSelector matchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        this.matchExpressions = matchExpressions;
        return this;
    }

    public LabelSelector addMatchExpressionsItem(LabelSelectorRequirement matchExpressionsItem) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList<LabelSelectorRequirement>();
        }
        this.matchExpressions.add(matchExpressionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="matchExpressions is a list of label selector requirements. The requirements are ANDed.")
    public List<LabelSelectorRequirement> getMatchExpressions() {
        return this.matchExpressions;
    }

    public void setMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
        this.matchExpressions = matchExpressions;
    }

    public LabelSelector matchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels;
        return this;
    }

    public LabelSelector putMatchLabelsItem(String key, String matchLabelsItem) {
        if (this.matchLabels == null) {
            this.matchLabels = new HashMap<String, String>();
        }
        this.matchLabels.put(key, matchLabelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.")
    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public void setMatchLabels(Map<String, String> matchLabels) {
        this.matchLabels = matchLabels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelSelector labelSelector = (LabelSelector)o;
        return Objects.equals(this.matchExpressions, labelSelector.matchExpressions) && Objects.equals(this.matchLabels, labelSelector.matchLabels);
    }

    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.matchLabels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LabelSelector {\n");
        sb.append("    matchExpressions: ").append(this.toIndentedString(this.matchExpressions)).append("\n");
        sb.append("    matchLabels: ").append(this.toIndentedString(this.matchLabels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

