/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1SecretKeySelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="S3EncryptionOptions used to determine encryption options during s3 operations")
public class IoArgoprojWorkflowV1alpha1S3EncryptionOptions {
    public static final String SERIALIZED_NAME_ENABLE_ENCRYPTION = "enableEncryption";
    @SerializedName(value="enableEncryption")
    private Boolean enableEncryption;
    public static final String SERIALIZED_NAME_KMS_ENCRYPTION_CONTEXT = "kmsEncryptionContext";
    @SerializedName(value="kmsEncryptionContext")
    private String kmsEncryptionContext;
    public static final String SERIALIZED_NAME_KMS_KEY_ID = "kmsKeyId";
    @SerializedName(value="kmsKeyId")
    private String kmsKeyId;
    public static final String SERIALIZED_NAME_SERVER_SIDE_CUSTOMER_KEY_SECRET = "serverSideCustomerKeySecret";
    @SerializedName(value="serverSideCustomerKeySecret")
    private V1SecretKeySelector serverSideCustomerKeySecret;

    public IoArgoprojWorkflowV1alpha1S3EncryptionOptions enableEncryption(Boolean enableEncryption) {
        this.enableEncryption = enableEncryption;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnableEncryption tells the driver to encrypt objects if set to true. If kmsKeyId and serverSideCustomerKeySecret are not set, SSE-S3 will be used")
    public Boolean getEnableEncryption() {
        return this.enableEncryption;
    }

    public void setEnableEncryption(Boolean enableEncryption) {
        this.enableEncryption = enableEncryption;
    }

    public IoArgoprojWorkflowV1alpha1S3EncryptionOptions kmsEncryptionContext(String kmsEncryptionContext) {
        this.kmsEncryptionContext = kmsEncryptionContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="KmsEncryptionContext is a json blob that contains an encryption context. See https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context for more information")
    public String getKmsEncryptionContext() {
        return this.kmsEncryptionContext;
    }

    public void setKmsEncryptionContext(String kmsEncryptionContext) {
        this.kmsEncryptionContext = kmsEncryptionContext;
    }

    public IoArgoprojWorkflowV1alpha1S3EncryptionOptions kmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="KMSKeyId tells the driver to encrypt the object using the specified KMS Key.")
    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public IoArgoprojWorkflowV1alpha1S3EncryptionOptions serverSideCustomerKeySecret(V1SecretKeySelector serverSideCustomerKeySecret) {
        this.serverSideCustomerKeySecret = serverSideCustomerKeySecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretKeySelector getServerSideCustomerKeySecret() {
        return this.serverSideCustomerKeySecret;
    }

    public void setServerSideCustomerKeySecret(V1SecretKeySelector serverSideCustomerKeySecret) {
        this.serverSideCustomerKeySecret = serverSideCustomerKeySecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoArgoprojWorkflowV1alpha1S3EncryptionOptions ioArgoprojWorkflowV1alpha1S3EncryptionOptions = (IoArgoprojWorkflowV1alpha1S3EncryptionOptions)o;
        return Objects.equals(this.enableEncryption, ioArgoprojWorkflowV1alpha1S3EncryptionOptions.enableEncryption) && Objects.equals(this.kmsEncryptionContext, ioArgoprojWorkflowV1alpha1S3EncryptionOptions.kmsEncryptionContext) && Objects.equals(this.kmsKeyId, ioArgoprojWorkflowV1alpha1S3EncryptionOptions.kmsKeyId) && Objects.equals(this.serverSideCustomerKeySecret, ioArgoprojWorkflowV1alpha1S3EncryptionOptions.serverSideCustomerKeySecret);
    }

    public int hashCode() {
        return Objects.hash(this.enableEncryption, this.kmsEncryptionContext, this.kmsKeyId, this.serverSideCustomerKeySecret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoArgoprojWorkflowV1alpha1S3EncryptionOptions {\n");
        sb.append("    enableEncryption: ").append(this.toIndentedString(this.enableEncryption)).append("\n");
        sb.append("    kmsEncryptionContext: ").append(this.toIndentedString(this.kmsEncryptionContext)).append("\n");
        sb.append("    kmsKeyId: ").append(this.toIndentedString(this.kmsKeyId)).append("\n");
        sb.append("    serverSideCustomerKeySecret: ").append(this.toIndentedString(this.serverSideCustomerKeySecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

