/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ConfigMapKeySelector;
import io.kubernetes.client.openapi.models.V1SecretKeySelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HDFSArtifactRepository defines the controller configuration for an HDFS artifact repository")
public class IoArgoprojWorkflowV1alpha1HDFSArtifactRepository {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<String> addresses = null;
    public static final String SERIALIZED_NAME_FORCE = "force";
    @SerializedName(value="force")
    private Boolean force;
    public static final String SERIALIZED_NAME_HDFS_USER = "hdfsUser";
    @SerializedName(value="hdfsUser")
    private String hdfsUser;
    public static final String SERIALIZED_NAME_KRB_C_CACHE_SECRET = "krbCCacheSecret";
    @SerializedName(value="krbCCacheSecret")
    private V1SecretKeySelector krbCCacheSecret;
    public static final String SERIALIZED_NAME_KRB_CONFIG_CONFIG_MAP = "krbConfigConfigMap";
    @SerializedName(value="krbConfigConfigMap")
    private V1ConfigMapKeySelector krbConfigConfigMap;
    public static final String SERIALIZED_NAME_KRB_KEYTAB_SECRET = "krbKeytabSecret";
    @SerializedName(value="krbKeytabSecret")
    private V1SecretKeySelector krbKeytabSecret;
    public static final String SERIALIZED_NAME_KRB_REALM = "krbRealm";
    @SerializedName(value="krbRealm")
    private String krbRealm;
    public static final String SERIALIZED_NAME_KRB_SERVICE_PRINCIPAL_NAME = "krbServicePrincipalName";
    @SerializedName(value="krbServicePrincipalName")
    private String krbServicePrincipalName;
    public static final String SERIALIZED_NAME_KRB_USERNAME = "krbUsername";
    @SerializedName(value="krbUsername")
    private String krbUsername;
    public static final String SERIALIZED_NAME_PATH_FORMAT = "pathFormat";
    @SerializedName(value="pathFormat")
    private String pathFormat;

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository addresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository addAddressesItem(String addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Addresses is accessible addresses of HDFS name nodes")
    public List<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository force(Boolean force) {
        this.force = force;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Force copies a file forcibly even if it exists")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository hdfsUser(String hdfsUser) {
        this.hdfsUser = hdfsUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HDFSUser is the user to access HDFS file system. It is ignored if either ccache or keytab is used.")
    public String getHdfsUser() {
        return this.hdfsUser;
    }

    public void setHdfsUser(String hdfsUser) {
        this.hdfsUser = hdfsUser;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository krbCCacheSecret(V1SecretKeySelector krbCCacheSecret) {
        this.krbCCacheSecret = krbCCacheSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretKeySelector getKrbCCacheSecret() {
        return this.krbCCacheSecret;
    }

    public void setKrbCCacheSecret(V1SecretKeySelector krbCCacheSecret) {
        this.krbCCacheSecret = krbCCacheSecret;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository krbConfigConfigMap(V1ConfigMapKeySelector krbConfigConfigMap) {
        this.krbConfigConfigMap = krbConfigConfigMap;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ConfigMapKeySelector getKrbConfigConfigMap() {
        return this.krbConfigConfigMap;
    }

    public void setKrbConfigConfigMap(V1ConfigMapKeySelector krbConfigConfigMap) {
        this.krbConfigConfigMap = krbConfigConfigMap;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository krbKeytabSecret(V1SecretKeySelector krbKeytabSecret) {
        this.krbKeytabSecret = krbKeytabSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretKeySelector getKrbKeytabSecret() {
        return this.krbKeytabSecret;
    }

    public void setKrbKeytabSecret(V1SecretKeySelector krbKeytabSecret) {
        this.krbKeytabSecret = krbKeytabSecret;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository krbRealm(String krbRealm) {
        this.krbRealm = krbRealm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="KrbRealm is the Kerberos realm used with Kerberos keytab It must be set if keytab is used.")
    public String getKrbRealm() {
        return this.krbRealm;
    }

    public void setKrbRealm(String krbRealm) {
        this.krbRealm = krbRealm;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository krbServicePrincipalName(String krbServicePrincipalName) {
        this.krbServicePrincipalName = krbServicePrincipalName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="KrbServicePrincipalName is the principal name of Kerberos service It must be set if either ccache or keytab is used.")
    public String getKrbServicePrincipalName() {
        return this.krbServicePrincipalName;
    }

    public void setKrbServicePrincipalName(String krbServicePrincipalName) {
        this.krbServicePrincipalName = krbServicePrincipalName;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository krbUsername(String krbUsername) {
        this.krbUsername = krbUsername;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="KrbUsername is the Kerberos username used with Kerberos keytab It must be set if keytab is used.")
    public String getKrbUsername() {
        return this.krbUsername;
    }

    public void setKrbUsername(String krbUsername) {
        this.krbUsername = krbUsername;
    }

    public IoArgoprojWorkflowV1alpha1HDFSArtifactRepository pathFormat(String pathFormat) {
        this.pathFormat = pathFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PathFormat is defines the format of path to store a file. Can reference workflow variables")
    public String getPathFormat() {
        return this.pathFormat;
    }

    public void setPathFormat(String pathFormat) {
        this.pathFormat = pathFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoArgoprojWorkflowV1alpha1HDFSArtifactRepository ioArgoprojWorkflowV1alpha1HDFSArtifactRepository = (IoArgoprojWorkflowV1alpha1HDFSArtifactRepository)o;
        return Objects.equals(this.addresses, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.addresses) && Objects.equals(this.force, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.force) && Objects.equals(this.hdfsUser, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.hdfsUser) && Objects.equals(this.krbCCacheSecret, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.krbCCacheSecret) && Objects.equals(this.krbConfigConfigMap, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.krbConfigConfigMap) && Objects.equals(this.krbKeytabSecret, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.krbKeytabSecret) && Objects.equals(this.krbRealm, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.krbRealm) && Objects.equals(this.krbServicePrincipalName, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.krbServicePrincipalName) && Objects.equals(this.krbUsername, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.krbUsername) && Objects.equals(this.pathFormat, ioArgoprojWorkflowV1alpha1HDFSArtifactRepository.pathFormat);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.force, this.hdfsUser, this.krbCCacheSecret, this.krbConfigConfigMap, this.krbKeytabSecret, this.krbRealm, this.krbServicePrincipalName, this.krbUsername, this.pathFormat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoArgoprojWorkflowV1alpha1HDFSArtifactRepository {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("    hdfsUser: ").append(this.toIndentedString(this.hdfsUser)).append("\n");
        sb.append("    krbCCacheSecret: ").append(this.toIndentedString(this.krbCCacheSecret)).append("\n");
        sb.append("    krbConfigConfigMap: ").append(this.toIndentedString(this.krbConfigConfigMap)).append("\n");
        sb.append("    krbKeytabSecret: ").append(this.toIndentedString(this.krbKeytabSecret)).append("\n");
        sb.append("    krbRealm: ").append(this.toIndentedString(this.krbRealm)).append("\n");
        sb.append("    krbServicePrincipalName: ").append(this.toIndentedString(this.krbServicePrincipalName)).append("\n");
        sb.append("    krbUsername: ").append(this.toIndentedString(this.krbUsername)).append("\n");
        sb.append("    pathFormat: ").append(this.toIndentedString(this.pathFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

