/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1SecretKeySelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="GitArtifact is the location of an git artifact")
public class IoArgoprojWorkflowV1alpha1GitArtifact {
    public static final String SERIALIZED_NAME_BRANCH = "branch";
    @SerializedName(value="branch")
    private String branch;
    public static final String SERIALIZED_NAME_DEPTH = "depth";
    @SerializedName(value="depth")
    private Integer depth;
    public static final String SERIALIZED_NAME_DISABLE_SUBMODULES = "disableSubmodules";
    @SerializedName(value="disableSubmodules")
    private Boolean disableSubmodules;
    public static final String SERIALIZED_NAME_FETCH = "fetch";
    @SerializedName(value="fetch")
    private List<String> fetch = null;
    public static final String SERIALIZED_NAME_INSECURE_IGNORE_HOST_KEY = "insecureIgnoreHostKey";
    @SerializedName(value="insecureIgnoreHostKey")
    private Boolean insecureIgnoreHostKey;
    public static final String SERIALIZED_NAME_PASSWORD_SECRET = "passwordSecret";
    @SerializedName(value="passwordSecret")
    private V1SecretKeySelector passwordSecret;
    public static final String SERIALIZED_NAME_REPO = "repo";
    @SerializedName(value="repo")
    private String repo;
    public static final String SERIALIZED_NAME_REVISION = "revision";
    @SerializedName(value="revision")
    private String revision;
    public static final String SERIALIZED_NAME_SINGLE_BRANCH = "singleBranch";
    @SerializedName(value="singleBranch")
    private Boolean singleBranch;
    public static final String SERIALIZED_NAME_SSH_PRIVATE_KEY_SECRET = "sshPrivateKeySecret";
    @SerializedName(value="sshPrivateKeySecret")
    private V1SecretKeySelector sshPrivateKeySecret;
    public static final String SERIALIZED_NAME_USERNAME_SECRET = "usernameSecret";
    @SerializedName(value="usernameSecret")
    private V1SecretKeySelector usernameSecret;

    public IoArgoprojWorkflowV1alpha1GitArtifact branch(String branch) {
        this.branch = branch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Branch is the branch to fetch when `SingleBranch` is enabled")
    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact depth(Integer depth) {
        this.depth = depth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Depth specifies clones/fetches should be shallow and include the given number of commits from the branch tip")
    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact disableSubmodules(Boolean disableSubmodules) {
        this.disableSubmodules = disableSubmodules;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DisableSubmodules disables submodules during git clone")
    public Boolean getDisableSubmodules() {
        return this.disableSubmodules;
    }

    public void setDisableSubmodules(Boolean disableSubmodules) {
        this.disableSubmodules = disableSubmodules;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact fetch(List<String> fetch) {
        this.fetch = fetch;
        return this;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact addFetchItem(String fetchItem) {
        if (this.fetch == null) {
            this.fetch = new ArrayList<String>();
        }
        this.fetch.add(fetchItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fetch specifies a number of refs that should be fetched before checkout")
    public List<String> getFetch() {
        return this.fetch;
    }

    public void setFetch(List<String> fetch) {
        this.fetch = fetch;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact insecureIgnoreHostKey(Boolean insecureIgnoreHostKey) {
        this.insecureIgnoreHostKey = insecureIgnoreHostKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InsecureIgnoreHostKey disables SSH strict host key checking during git clone")
    public Boolean getInsecureIgnoreHostKey() {
        return this.insecureIgnoreHostKey;
    }

    public void setInsecureIgnoreHostKey(Boolean insecureIgnoreHostKey) {
        this.insecureIgnoreHostKey = insecureIgnoreHostKey;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact passwordSecret(V1SecretKeySelector passwordSecret) {
        this.passwordSecret = passwordSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretKeySelector getPasswordSecret() {
        return this.passwordSecret;
    }

    public void setPasswordSecret(V1SecretKeySelector passwordSecret) {
        this.passwordSecret = passwordSecret;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact repo(String repo) {
        this.repo = repo;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Repo is the git repository")
    public String getRepo() {
        return this.repo;
    }

    public void setRepo(String repo) {
        this.repo = repo;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact revision(String revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Revision is the git commit, tag, branch to checkout")
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact singleBranch(Boolean singleBranch) {
        this.singleBranch = singleBranch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SingleBranch enables single branch clone, using the `branch` parameter")
    public Boolean getSingleBranch() {
        return this.singleBranch;
    }

    public void setSingleBranch(Boolean singleBranch) {
        this.singleBranch = singleBranch;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact sshPrivateKeySecret(V1SecretKeySelector sshPrivateKeySecret) {
        this.sshPrivateKeySecret = sshPrivateKeySecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretKeySelector getSshPrivateKeySecret() {
        return this.sshPrivateKeySecret;
    }

    public void setSshPrivateKeySecret(V1SecretKeySelector sshPrivateKeySecret) {
        this.sshPrivateKeySecret = sshPrivateKeySecret;
    }

    public IoArgoprojWorkflowV1alpha1GitArtifact usernameSecret(V1SecretKeySelector usernameSecret) {
        this.usernameSecret = usernameSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretKeySelector getUsernameSecret() {
        return this.usernameSecret;
    }

    public void setUsernameSecret(V1SecretKeySelector usernameSecret) {
        this.usernameSecret = usernameSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoArgoprojWorkflowV1alpha1GitArtifact ioArgoprojWorkflowV1alpha1GitArtifact = (IoArgoprojWorkflowV1alpha1GitArtifact)o;
        return Objects.equals(this.branch, ioArgoprojWorkflowV1alpha1GitArtifact.branch) && Objects.equals(this.depth, ioArgoprojWorkflowV1alpha1GitArtifact.depth) && Objects.equals(this.disableSubmodules, ioArgoprojWorkflowV1alpha1GitArtifact.disableSubmodules) && Objects.equals(this.fetch, ioArgoprojWorkflowV1alpha1GitArtifact.fetch) && Objects.equals(this.insecureIgnoreHostKey, ioArgoprojWorkflowV1alpha1GitArtifact.insecureIgnoreHostKey) && Objects.equals(this.passwordSecret, ioArgoprojWorkflowV1alpha1GitArtifact.passwordSecret) && Objects.equals(this.repo, ioArgoprojWorkflowV1alpha1GitArtifact.repo) && Objects.equals(this.revision, ioArgoprojWorkflowV1alpha1GitArtifact.revision) && Objects.equals(this.singleBranch, ioArgoprojWorkflowV1alpha1GitArtifact.singleBranch) && Objects.equals(this.sshPrivateKeySecret, ioArgoprojWorkflowV1alpha1GitArtifact.sshPrivateKeySecret) && Objects.equals(this.usernameSecret, ioArgoprojWorkflowV1alpha1GitArtifact.usernameSecret);
    }

    public int hashCode() {
        return Objects.hash(this.branch, this.depth, this.disableSubmodules, this.fetch, this.insecureIgnoreHostKey, this.passwordSecret, this.repo, this.revision, this.singleBranch, this.sshPrivateKeySecret, this.usernameSecret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoArgoprojWorkflowV1alpha1GitArtifact {\n");
        sb.append("    branch: ").append(this.toIndentedString(this.branch)).append("\n");
        sb.append("    depth: ").append(this.toIndentedString(this.depth)).append("\n");
        sb.append("    disableSubmodules: ").append(this.toIndentedString(this.disableSubmodules)).append("\n");
        sb.append("    fetch: ").append(this.toIndentedString(this.fetch)).append("\n");
        sb.append("    insecureIgnoreHostKey: ").append(this.toIndentedString(this.insecureIgnoreHostKey)).append("\n");
        sb.append("    passwordSecret: ").append(this.toIndentedString(this.passwordSecret)).append("\n");
        sb.append("    repo: ").append(this.toIndentedString(this.repo)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("    singleBranch: ").append(this.toIndentedString(this.singleBranch)).append("\n");
        sb.append("    sshPrivateKeySecret: ").append(this.toIndentedString(this.sshPrivateKeySecret)).append("\n");
        sb.append("    usernameSecret: ").append(this.toIndentedString(this.usernameSecret)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

