/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1DAGTask;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="DAGTemplate is a template subtype for directed acyclic graph templates")
public class IoArgoprojWorkflowV1alpha1DAGTemplate {
    public static final String SERIALIZED_NAME_FAIL_FAST = "failFast";
    @SerializedName(value="failFast")
    private Boolean failFast;
    public static final String SERIALIZED_NAME_TARGET = "target";
    @SerializedName(value="target")
    private String target;
    public static final String SERIALIZED_NAME_TASKS = "tasks";
    @SerializedName(value="tasks")
    private List<IoArgoprojWorkflowV1alpha1DAGTask> tasks = new ArrayList<IoArgoprojWorkflowV1alpha1DAGTask>();

    public IoArgoprojWorkflowV1alpha1DAGTemplate failFast(Boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This flag is for DAG logic. The DAG logic has a built-in \"fail fast\" feature to stop scheduling new steps, as soon as it detects that one of the DAG nodes is failed. Then it waits until all DAG nodes are completed before failing the DAG itself. The FailFast flag default is true,  if set to false, it will allow a DAG to run all branches of the DAG to completion (either success or failure), regardless of the failed outcomes of branches in the DAG. More info and example about this feature at https://github.com/argoproj/argo-workflows/issues/1442")
    public Boolean getFailFast() {
        return this.failFast;
    }

    public void setFailFast(Boolean failFast) {
        this.failFast = failFast;
    }

    public IoArgoprojWorkflowV1alpha1DAGTemplate target(String target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Target are one or more names of targets to execute in a DAG")
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public IoArgoprojWorkflowV1alpha1DAGTemplate tasks(List<IoArgoprojWorkflowV1alpha1DAGTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    public IoArgoprojWorkflowV1alpha1DAGTemplate addTasksItem(IoArgoprojWorkflowV1alpha1DAGTask tasksItem) {
        this.tasks.add(tasksItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Tasks are a list of DAG tasks")
    public List<IoArgoprojWorkflowV1alpha1DAGTask> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<IoArgoprojWorkflowV1alpha1DAGTask> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoArgoprojWorkflowV1alpha1DAGTemplate ioArgoprojWorkflowV1alpha1DAGTemplate = (IoArgoprojWorkflowV1alpha1DAGTemplate)o;
        return Objects.equals(this.failFast, ioArgoprojWorkflowV1alpha1DAGTemplate.failFast) && Objects.equals(this.target, ioArgoprojWorkflowV1alpha1DAGTemplate.target) && Objects.equals(this.tasks, ioArgoprojWorkflowV1alpha1DAGTemplate.tasks);
    }

    public int hashCode() {
        return Objects.hash(this.failFast, this.target, this.tasks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoArgoprojWorkflowV1alpha1DAGTemplate {\n");
        sb.append("    failFast: ").append(this.toIndentedString(this.failFast)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    tasks: ").append(this.toIndentedString(this.tasks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

