/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1SecretKeySelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="AzureArtifactRepository defines the controller configuration for an Azure Blob Storage artifact repository")
public class IoArgoprojWorkflowV1alpha1AzureArtifactRepository {
    public static final String SERIALIZED_NAME_ACCOUNT_KEY_SECRET = "accountKeySecret";
    @SerializedName(value="accountKeySecret")
    private V1SecretKeySelector accountKeySecret;
    public static final String SERIALIZED_NAME_BLOB_NAME_FORMAT = "blobNameFormat";
    @SerializedName(value="blobNameFormat")
    private String blobNameFormat;
    public static final String SERIALIZED_NAME_CONTAINER = "container";
    @SerializedName(value="container")
    private String container;
    public static final String SERIALIZED_NAME_ENDPOINT = "endpoint";
    @SerializedName(value="endpoint")
    private String endpoint;
    public static final String SERIALIZED_NAME_USE_S_D_K_CREDS = "useSDKCreds";
    @SerializedName(value="useSDKCreds")
    private Boolean useSDKCreds;

    public IoArgoprojWorkflowV1alpha1AzureArtifactRepository accountKeySecret(V1SecretKeySelector accountKeySecret) {
        this.accountKeySecret = accountKeySecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecretKeySelector getAccountKeySecret() {
        return this.accountKeySecret;
    }

    public void setAccountKeySecret(V1SecretKeySelector accountKeySecret) {
        this.accountKeySecret = accountKeySecret;
    }

    public IoArgoprojWorkflowV1alpha1AzureArtifactRepository blobNameFormat(String blobNameFormat) {
        this.blobNameFormat = blobNameFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BlobNameFormat is defines the format of how to store blob names. Can reference workflow variables")
    public String getBlobNameFormat() {
        return this.blobNameFormat;
    }

    public void setBlobNameFormat(String blobNameFormat) {
        this.blobNameFormat = blobNameFormat;
    }

    public IoArgoprojWorkflowV1alpha1AzureArtifactRepository container(String container) {
        this.container = container;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Container is the container where resources will be stored")
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public IoArgoprojWorkflowV1alpha1AzureArtifactRepository endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Endpoint is the service url associated with an account. It is most likely \"https://<ACCOUNT_NAME>.blob.core.windows.net\"")
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public IoArgoprojWorkflowV1alpha1AzureArtifactRepository useSDKCreds(Boolean useSDKCreds) {
        this.useSDKCreds = useSDKCreds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UseSDKCreds tells the driver to figure out credentials based on sdk defaults.")
    public Boolean getUseSDKCreds() {
        return this.useSDKCreds;
    }

    public void setUseSDKCreds(Boolean useSDKCreds) {
        this.useSDKCreds = useSDKCreds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoArgoprojWorkflowV1alpha1AzureArtifactRepository ioArgoprojWorkflowV1alpha1AzureArtifactRepository = (IoArgoprojWorkflowV1alpha1AzureArtifactRepository)o;
        return Objects.equals(this.accountKeySecret, ioArgoprojWorkflowV1alpha1AzureArtifactRepository.accountKeySecret) && Objects.equals(this.blobNameFormat, ioArgoprojWorkflowV1alpha1AzureArtifactRepository.blobNameFormat) && Objects.equals(this.container, ioArgoprojWorkflowV1alpha1AzureArtifactRepository.container) && Objects.equals(this.endpoint, ioArgoprojWorkflowV1alpha1AzureArtifactRepository.endpoint) && Objects.equals(this.useSDKCreds, ioArgoprojWorkflowV1alpha1AzureArtifactRepository.useSDKCreds);
    }

    public int hashCode() {
        return Objects.hash(this.accountKeySecret, this.blobNameFormat, this.container, this.endpoint, this.useSDKCreds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoArgoprojWorkflowV1alpha1AzureArtifactRepository {\n");
        sb.append("    accountKeySecret: ").append(this.toIndentedString(this.accountKeySecret)).append("\n");
        sb.append("    blobNameFormat: ").append(this.toIndentedString(this.blobNameFormat)).append("\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    useSDKCreds: ").append(this.toIndentedString(this.useSDKCreds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

