/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TimeFilter describes a window in time. It filters out events that occur outside the time limits. In other words, only events that occur after Start and before Stop will pass this filter.")
public class IoArgoprojEventsV1alpha1TimeFilter {
    public static final String SERIALIZED_NAME_START = "start";
    @SerializedName(value="start")
    private String start;
    public static final String SERIALIZED_NAME_STOP = "stop";
    @SerializedName(value="stop")
    private String stop;

    public IoArgoprojEventsV1alpha1TimeFilter start(String start) {
        this.start = start;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Start is the beginning of a time window in UTC. Before this time, events for this dependency are ignored. Format is hh:mm:ss.")
    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public IoArgoprojEventsV1alpha1TimeFilter stop(String stop) {
        this.stop = stop;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Stop is the end of a time window in UTC. After or equal to this time, events for this dependency are ignored and Format is hh:mm:ss. If it is smaller than Start, it is treated as next day of Start (e.g.: 22:00:00-01:00:00 means 22:00:00-25:00:00).")
    public String getStop() {
        return this.stop;
    }

    public void setStop(String stop) {
        this.stop = stop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoArgoprojEventsV1alpha1TimeFilter ioArgoprojEventsV1alpha1TimeFilter = (IoArgoprojEventsV1alpha1TimeFilter)o;
        return Objects.equals(this.start, ioArgoprojEventsV1alpha1TimeFilter.start) && Objects.equals(this.stop, ioArgoprojEventsV1alpha1TimeFilter.stop);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.stop);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoArgoprojEventsV1alpha1TimeFilter {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    stop: ").append(this.toIndentedString(this.stop)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

