/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.")
public class HostPathVolumeSource {
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public HostPathVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public HostPathVolumeSource type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type for HostPath Volume Defaults to \"\" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostPathVolumeSource hostPathVolumeSource = (HostPathVolumeSource)o;
        return Objects.equals(this.path, hostPathVolumeSource.path) && Objects.equals(this.type, hostPathVolumeSource.type);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HostPathVolumeSource {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

