/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GRPCAction {
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private Integer port;
    public static final String SERIALIZED_NAME_SERVICE = "service";
    @SerializedName(value="service")
    private String service;

    public GRPCAction port(Integer port) {
        this.port = port;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Port number of the gRPC service. Number must be in the range 1 to 65535.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public GRPCAction service(String service) {
        this.service = service;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Service is the name of the service to place in the gRPC HealthCheckRequest (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).  If this is not specified, the default behavior is defined by gRPC.")
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GRPCAction grPCAction = (GRPCAction)o;
        return Objects.equals(this.port, grPCAction.port) && Objects.equals(this.service, grPCAction.service);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GRPCAction {\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

