/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EventSource contains information for an event.")
public class EventSource {
    public static final String SERIALIZED_NAME_COMPONENT = "component";
    @SerializedName(value="component")
    private String component;
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    private String host;

    public EventSource component(String component) {
        this.component = component;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Component from which the event is generated.")
    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public EventSource host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Node name on which the event is generated.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSource eventSource = (EventSource)o;
        return Objects.equals(this.component, eventSource.component) && Objects.equals(this.host, eventSource.host);
    }

    public int hashCode() {
        return Objects.hash(this.component, this.host);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventSource {\n");
        sb.append("    component: ").append(this.toIndentedString(this.component)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

