/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.")
public class EventSeries {
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;
    public static final String SERIALIZED_NAME_LAST_OBSERVED_TIME = "lastObservedTime";
    @SerializedName(value="lastObservedTime")
    private OffsetDateTime lastObservedTime;

    public EventSeries count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of occurrences in this series up to the last heartbeat time")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public EventSeries lastObservedTime(OffsetDateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MicroTime is version of Time with microsecond level precision.")
    public OffsetDateTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    public void setLastObservedTime(OffsetDateTime lastObservedTime) {
        this.lastObservedTime = lastObservedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSeries eventSeries = (EventSeries)o;
        return Objects.equals(this.count, eventSeries.count) && Objects.equals(this.lastObservedTime, eventSeries.lastObservedTime);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.lastObservedTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventSeries {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    lastObservedTime: ").append(this.toIndentedString(this.lastObservedTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

