/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.DownwardAPIVolumeFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.")
public class DownwardAPIVolumeSource {
    public static final String SERIALIZED_NAME_DEFAULT_MODE = "defaultMode";
    @SerializedName(value="defaultMode")
    private Integer defaultMode;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<DownwardAPIVolumeFile> items = null;

    public DownwardAPIVolumeSource defaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public DownwardAPIVolumeSource items(List<DownwardAPIVolumeFile> items) {
        this.items = items;
        return this;
    }

    public DownwardAPIVolumeSource addItemsItem(DownwardAPIVolumeFile itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<DownwardAPIVolumeFile>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Items is a list of downward API volume file")
    public List<DownwardAPIVolumeFile> getItems() {
        return this.items;
    }

    public void setItems(List<DownwardAPIVolumeFile> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownwardAPIVolumeSource downwardAPIVolumeSource = (DownwardAPIVolumeSource)o;
        return Objects.equals(this.defaultMode, downwardAPIVolumeSource.defaultMode) && Objects.equals(this.items, downwardAPIVolumeSource.items);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DownwardAPIVolumeSource {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

