/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.ObjectFieldSelector;
import io.argoproj.workflow.models.ResourceFieldSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="DownwardAPIVolumeFile represents information to create the file containing the pod field")
public class DownwardAPIVolumeFile {
    public static final String SERIALIZED_NAME_FIELD_REF = "fieldRef";
    @SerializedName(value="fieldRef")
    private ObjectFieldSelector fieldRef;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    private Integer mode;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_RESOURCE_FIELD_REF = "resourceFieldRef";
    @SerializedName(value="resourceFieldRef")
    private ResourceFieldSelector resourceFieldRef;

    public DownwardAPIVolumeFile fieldRef(ObjectFieldSelector fieldRef) {
        this.fieldRef = fieldRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ObjectFieldSelector getFieldRef() {
        return this.fieldRef;
    }

    public void setFieldRef(ObjectFieldSelector fieldRef) {
        this.fieldRef = fieldRef;
    }

    public DownwardAPIVolumeFile mode(Integer mode) {
        this.mode = mode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getMode() {
        return this.mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public DownwardAPIVolumeFile path(String path) {
        this.path = path;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DownwardAPIVolumeFile resourceFieldRef(ResourceFieldSelector resourceFieldRef) {
        this.resourceFieldRef = resourceFieldRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ResourceFieldSelector getResourceFieldRef() {
        return this.resourceFieldRef;
    }

    public void setResourceFieldRef(ResourceFieldSelector resourceFieldRef) {
        this.resourceFieldRef = resourceFieldRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownwardAPIVolumeFile downwardAPIVolumeFile = (DownwardAPIVolumeFile)o;
        return Objects.equals(this.fieldRef, downwardAPIVolumeFile.fieldRef) && Objects.equals(this.mode, downwardAPIVolumeFile.mode) && Objects.equals(this.path, downwardAPIVolumeFile.path) && Objects.equals(this.resourceFieldRef, downwardAPIVolumeFile.resourceFieldRef);
    }

    public int hashCode() {
        return Objects.hash(this.fieldRef, this.mode, this.path, this.resourceFieldRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DownwardAPIVolumeFile {\n");
        sb.append("    fieldRef: ").append(this.toIndentedString(this.fieldRef)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    resourceFieldRef: ").append(this.toIndentedString(this.resourceFieldRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

