/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.argoproj.workflow.models.KeyToPath;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Adapts a ConfigMap into a volume.  The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.")
public class ConfigMapVolumeSource {
    public static final String SERIALIZED_NAME_DEFAULT_MODE = "defaultMode";
    @SerializedName(value="defaultMode")
    private Integer defaultMode;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<KeyToPath> items = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    private Boolean optional;

    public ConfigMapVolumeSource defaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.")
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
    }

    public ConfigMapVolumeSource items(List<KeyToPath> items) {
        this.items = items;
        return this;
    }

    public ConfigMapVolumeSource addItemsItem(KeyToPath itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<KeyToPath>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.")
    public List<KeyToPath> getItems() {
        return this.items;
    }

    public void setItems(List<KeyToPath> items) {
        this.items = items;
    }

    public ConfigMapVolumeSource name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConfigMapVolumeSource optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify whether the ConfigMap or its keys must be defined")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigMapVolumeSource configMapVolumeSource = (ConfigMapVolumeSource)o;
        return Objects.equals(this.defaultMode, configMapVolumeSource.defaultMode) && Objects.equals(this.items, configMapVolumeSource.items) && Objects.equals(this.name, configMapVolumeSource.name) && Objects.equals(this.optional, configMapVolumeSource.optional);
    }

    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.name, this.optional);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfigMapVolumeSource {\n");
        sb.append("    defaultMode: ").append(this.toIndentedString(this.defaultMode)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

