/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Adds and removes POSIX capabilities from running containers.")
public class Capabilities {
    public static final String SERIALIZED_NAME_ADD = "add";
    @SerializedName(value="add")
    private List<String> add = null;
    public static final String SERIALIZED_NAME_DROP = "drop";
    @SerializedName(value="drop")
    private List<String> drop = null;

    public Capabilities add(List<String> add) {
        this.add = add;
        return this;
    }

    public Capabilities addAddItem(String addItem) {
        if (this.add == null) {
            this.add = new ArrayList<String>();
        }
        this.add.add(addItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Added capabilities")
    public List<String> getAdd() {
        return this.add;
    }

    public void setAdd(List<String> add) {
        this.add = add;
    }

    public Capabilities drop(List<String> drop) {
        this.drop = drop;
        return this;
    }

    public Capabilities addDropItem(String dropItem) {
        if (this.drop == null) {
            this.drop = new ArrayList<String>();
        }
        this.drop.add(dropItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Removed capabilities")
    public List<String> getDrop() {
        return this.drop;
    }

    public void setDrop(List<String> drop) {
        this.drop = drop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capabilities capabilities = (Capabilities)o;
        return Objects.equals(this.add, capabilities.add) && Objects.equals(this.drop, capabilities.drop);
    }

    public int hashCode() {
        return Objects.hash(this.add, this.drop);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Capabilities {\n");
        sb.append("    add: ").append(this.toIndentedString(this.add)).append("\n");
        sb.append("    drop: ").append(this.toIndentedString(this.drop)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

