/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.")
public class AzureDiskVolumeSource {
    public static final String SERIALIZED_NAME_CACHING_MODE = "cachingMode";
    @SerializedName(value="cachingMode")
    private String cachingMode;
    public static final String SERIALIZED_NAME_DISK_NAME = "diskName";
    @SerializedName(value="diskName")
    private String diskName;
    public static final String SERIALIZED_NAME_DISK_U_R_I = "diskURI";
    @SerializedName(value="diskURI")
    private String diskURI;
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;

    public AzureDiskVolumeSource cachingMode(String cachingMode) {
        this.cachingMode = cachingMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host Caching mode: None, Read Only, Read Write.")
    public String getCachingMode() {
        return this.cachingMode;
    }

    public void setCachingMode(String cachingMode) {
        this.cachingMode = cachingMode;
    }

    public AzureDiskVolumeSource diskName(String diskName) {
        this.diskName = diskName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The Name of the data disk in the blob storage")
    public String getDiskName() {
        return this.diskName;
    }

    public void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    public AzureDiskVolumeSource diskURI(String diskURI) {
        this.diskURI = diskURI;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The URI the data disk in the blob storage")
    public String getDiskURI() {
        return this.diskURI;
    }

    public void setDiskURI(String diskURI) {
        this.diskURI = diskURI;
    }

    public AzureDiskVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public AzureDiskVolumeSource kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public AzureDiskVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureDiskVolumeSource azureDiskVolumeSource = (AzureDiskVolumeSource)o;
        return Objects.equals(this.cachingMode, azureDiskVolumeSource.cachingMode) && Objects.equals(this.diskName, azureDiskVolumeSource.diskName) && Objects.equals(this.diskURI, azureDiskVolumeSource.diskURI) && Objects.equals(this.fsType, azureDiskVolumeSource.fsType) && Objects.equals(this.kind, azureDiskVolumeSource.kind) && Objects.equals(this.readOnly, azureDiskVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.cachingMode, this.diskName, this.diskURI, this.fsType, this.kind, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureDiskVolumeSource {\n");
        sb.append("    cachingMode: ").append(this.toIndentedString(this.cachingMode)).append("\n");
        sb.append("    diskName: ").append(this.toIndentedString(this.diskName)).append("\n");
        sb.append("    diskURI: ").append(this.toIndentedString(this.diskURI)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

