/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.auth;

import io.argoproj.workflow.Pair;
import io.argoproj.workflow.auth.Authentication;
import java.util.List;
import java.util.Map;

public class HttpBearerAuth
implements Authentication {
    private final String scheme;
    private String bearerToken;

    public HttpBearerAuth(String scheme) {
        this.scheme = scheme;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        if (this.bearerToken == null) {
            return;
        }
        headerParams.put("Authorization", (this.scheme != null ? HttpBearerAuth.upperCaseBearer(this.scheme) + " " : "") + this.bearerToken);
    }

    private static String upperCaseBearer(String scheme) {
        return "bearer".equalsIgnoreCase(scheme) ? "Bearer" : scheme;
    }
}

