/*
 * Decompiled with CFR 0.152.
 */
package io.argoproj.workflow.apis;

import com.google.gson.reflect.TypeToken;
import io.argoproj.workflow.ApiCallback;
import io.argoproj.workflow.ApiClient;
import io.argoproj.workflow.ApiException;
import io.argoproj.workflow.ApiResponse;
import io.argoproj.workflow.Configuration;
import io.argoproj.workflow.Pair;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1Workflow;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowCreateRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowLintRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowList;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowResumeRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowRetryRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowSetRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowStopRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest;
import io.argoproj.workflow.models.IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest;
import io.argoproj.workflow.models.StreamResultOfEvent;
import io.argoproj.workflow.models.StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry;
import io.argoproj.workflow.models.StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class WorkflowServiceApi {
    private ApiClient localVarApiClient;

    public WorkflowServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call workflowServiceCreateWorkflowCall(String namespace, IoArgoprojWorkflowV1alpha1WorkflowCreateRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowCreateRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceCreateWorkflowValidateBeforeCall(String namespace, IoArgoprojWorkflowV1alpha1WorkflowCreateRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceCreateWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceCreateWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceCreateWorkflowCall(namespace, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceCreateWorkflow(String namespace, IoArgoprojWorkflowV1alpha1WorkflowCreateRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceCreateWorkflowWithHttpInfo(namespace, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceCreateWorkflowWithHttpInfo(String namespace, IoArgoprojWorkflowV1alpha1WorkflowCreateRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceCreateWorkflowValidateBeforeCall(namespace, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceCreateWorkflowAsync(String namespace, IoArgoprojWorkflowV1alpha1WorkflowCreateRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceCreateWorkflowValidateBeforeCall(namespace, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceDeleteWorkflowCall(String namespace, String name, String deleteOptionsGracePeriodSeconds, String deleteOptionsPreconditionsUid, String deleteOptionsPreconditionsResourceVersion, Boolean deleteOptionsOrphanDependents, String deleteOptionsPropagationPolicy, List<String> deleteOptionsDryRun, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (deleteOptionsGracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleteOptions.gracePeriodSeconds", deleteOptionsGracePeriodSeconds));
        }
        if (deleteOptionsPreconditionsUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleteOptions.preconditions.uid", deleteOptionsPreconditionsUid));
        }
        if (deleteOptionsPreconditionsResourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleteOptions.preconditions.resourceVersion", deleteOptionsPreconditionsResourceVersion));
        }
        if (deleteOptionsOrphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleteOptions.orphanDependents", deleteOptionsOrphanDependents));
        }
        if (deleteOptionsPropagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleteOptions.propagationPolicy", deleteOptionsPropagationPolicy));
        }
        if (deleteOptionsDryRun != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "deleteOptions.dryRun", deleteOptionsDryRun));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceDeleteWorkflowValidateBeforeCall(String namespace, String name, String deleteOptionsGracePeriodSeconds, String deleteOptionsPreconditionsUid, String deleteOptionsPreconditionsResourceVersion, Boolean deleteOptionsOrphanDependents, String deleteOptionsPropagationPolicy, List<String> deleteOptionsDryRun, Boolean force, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceDeleteWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceDeleteWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceDeleteWorkflowCall(namespace, name, deleteOptionsGracePeriodSeconds, deleteOptionsPreconditionsUid, deleteOptionsPreconditionsResourceVersion, deleteOptionsOrphanDependents, deleteOptionsPropagationPolicy, deleteOptionsDryRun, force, _callback);
        return localVarCall;
    }

    public Object workflowServiceDeleteWorkflow(String namespace, String name, String deleteOptionsGracePeriodSeconds, String deleteOptionsPreconditionsUid, String deleteOptionsPreconditionsResourceVersion, Boolean deleteOptionsOrphanDependents, String deleteOptionsPropagationPolicy, List<String> deleteOptionsDryRun, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResp = this.workflowServiceDeleteWorkflowWithHttpInfo(namespace, name, deleteOptionsGracePeriodSeconds, deleteOptionsPreconditionsUid, deleteOptionsPreconditionsResourceVersion, deleteOptionsOrphanDependents, deleteOptionsPropagationPolicy, deleteOptionsDryRun, force);
        return localVarResp.getData();
    }

    public ApiResponse<Object> workflowServiceDeleteWorkflowWithHttpInfo(String namespace, String name, String deleteOptionsGracePeriodSeconds, String deleteOptionsPreconditionsUid, String deleteOptionsPreconditionsResourceVersion, Boolean deleteOptionsOrphanDependents, String deleteOptionsPropagationPolicy, List<String> deleteOptionsDryRun, Boolean force) throws ApiException {
        Call localVarCall = this.workflowServiceDeleteWorkflowValidateBeforeCall(namespace, name, deleteOptionsGracePeriodSeconds, deleteOptionsPreconditionsUid, deleteOptionsPreconditionsResourceVersion, deleteOptionsOrphanDependents, deleteOptionsPropagationPolicy, deleteOptionsDryRun, force, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceDeleteWorkflowAsync(String namespace, String name, String deleteOptionsGracePeriodSeconds, String deleteOptionsPreconditionsUid, String deleteOptionsPreconditionsResourceVersion, Boolean deleteOptionsOrphanDependents, String deleteOptionsPropagationPolicy, List<String> deleteOptionsDryRun, Boolean force, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceDeleteWorkflowValidateBeforeCall(namespace, name, deleteOptionsGracePeriodSeconds, deleteOptionsPreconditionsUid, deleteOptionsPreconditionsResourceVersion, deleteOptionsOrphanDependents, deleteOptionsPropagationPolicy, deleteOptionsDryRun, force, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceGetWorkflowCall(String namespace, String name, String getOptionsResourceVersion, String fields, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (getOptionsResourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("getOptions.resourceVersion", getOptionsResourceVersion));
        }
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceGetWorkflowValidateBeforeCall(String namespace, String name, String getOptionsResourceVersion, String fields, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceGetWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceGetWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceGetWorkflowCall(namespace, name, getOptionsResourceVersion, fields, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceGetWorkflow(String namespace, String name, String getOptionsResourceVersion, String fields) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceGetWorkflowWithHttpInfo(namespace, name, getOptionsResourceVersion, fields);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceGetWorkflowWithHttpInfo(String namespace, String name, String getOptionsResourceVersion, String fields) throws ApiException {
        Call localVarCall = this.workflowServiceGetWorkflowValidateBeforeCall(namespace, name, getOptionsResourceVersion, fields, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceGetWorkflowAsync(String namespace, String name, String getOptionsResourceVersion, String fields, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceGetWorkflowValidateBeforeCall(namespace, name, getOptionsResourceVersion, fields, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceLintWorkflowCall(String namespace, IoArgoprojWorkflowV1alpha1WorkflowLintRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowLintRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/lint".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceLintWorkflowValidateBeforeCall(String namespace, IoArgoprojWorkflowV1alpha1WorkflowLintRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceLintWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceLintWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceLintWorkflowCall(namespace, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceLintWorkflow(String namespace, IoArgoprojWorkflowV1alpha1WorkflowLintRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceLintWorkflowWithHttpInfo(namespace, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceLintWorkflowWithHttpInfo(String namespace, IoArgoprojWorkflowV1alpha1WorkflowLintRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceLintWorkflowValidateBeforeCall(namespace, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceLintWorkflowAsync(String namespace, IoArgoprojWorkflowV1alpha1WorkflowLintRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceLintWorkflowValidateBeforeCall(namespace, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceListWorkflowsCall(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/workflows/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listOptionsLabelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.labelSelector", listOptionsLabelSelector));
        }
        if (listOptionsFieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.fieldSelector", listOptionsFieldSelector));
        }
        if (listOptionsWatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.watch", listOptionsWatch));
        }
        if (listOptionsAllowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.allowWatchBookmarks", listOptionsAllowWatchBookmarks));
        }
        if (listOptionsResourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.resourceVersion", listOptionsResourceVersion));
        }
        if (listOptionsResourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.resourceVersionMatch", listOptionsResourceVersionMatch));
        }
        if (listOptionsTimeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.timeoutSeconds", listOptionsTimeoutSeconds));
        }
        if (listOptionsLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.limit", listOptionsLimit));
        }
        if (listOptionsContinue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.continue", listOptionsContinue));
        }
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceListWorkflowsValidateBeforeCall(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceListWorkflows(Async)");
        }
        Call localVarCall = this.workflowServiceListWorkflowsCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1WorkflowList workflowServiceListWorkflows(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1WorkflowList> localVarResp = this.workflowServiceListWorkflowsWithHttpInfo(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1WorkflowList> workflowServiceListWorkflowsWithHttpInfo(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields) throws ApiException {
        Call localVarCall = this.workflowServiceListWorkflowsValidateBeforeCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1WorkflowList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceListWorkflowsAsync(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields, ApiCallback<IoArgoprojWorkflowV1alpha1WorkflowList> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceListWorkflowsValidateBeforeCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1WorkflowList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServicePodLogsCall(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/{podName}/log".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString())).replaceAll("\\{podName\\}", this.localVarApiClient.escapeString(podName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (logOptionsContainer != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.container", logOptionsContainer));
        }
        if (logOptionsFollow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.follow", logOptionsFollow));
        }
        if (logOptionsPrevious != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.previous", logOptionsPrevious));
        }
        if (logOptionsSinceSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.sinceSeconds", logOptionsSinceSeconds));
        }
        if (logOptionsSinceTimeSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.sinceTime.seconds", logOptionsSinceTimeSeconds));
        }
        if (logOptionsSinceTimeNanos != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.sinceTime.nanos", logOptionsSinceTimeNanos));
        }
        if (logOptionsTimestamps != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.timestamps", logOptionsTimestamps));
        }
        if (logOptionsTailLines != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.tailLines", logOptionsTailLines));
        }
        if (logOptionsLimitBytes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.limitBytes", logOptionsLimitBytes));
        }
        if (logOptionsInsecureSkipTLSVerifyBackend != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.insecureSkipTLSVerifyBackend", logOptionsInsecureSkipTLSVerifyBackend));
        }
        if (grep != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("grep", grep));
        }
        if (selector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("selector", selector));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServicePodLogsValidateBeforeCall(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServicePodLogs(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServicePodLogs(Async)");
        }
        if (podName == null) {
            throw new ApiException("Missing the required parameter 'podName' when calling workflowServicePodLogs(Async)");
        }
        Call localVarCall = this.workflowServicePodLogsCall(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector, _callback);
        return localVarCall;
    }

    public StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry workflowServicePodLogs(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector) throws ApiException {
        ApiResponse<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry> localVarResp = this.workflowServicePodLogsWithHttpInfo(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector);
        return localVarResp.getData();
    }

    public ApiResponse<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry> workflowServicePodLogsWithHttpInfo(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector) throws ApiException {
        Call localVarCall = this.workflowServicePodLogsValidateBeforeCall(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector, null);
        Type localVarReturnType = new TypeToken<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServicePodLogsAsync(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector, ApiCallback<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry> _callback) throws ApiException {
        Call localVarCall = this.workflowServicePodLogsValidateBeforeCall(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector, _callback);
        Type localVarReturnType = new TypeToken<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceResubmitWorkflowCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/resubmit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceResubmitWorkflowValidateBeforeCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceResubmitWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceResubmitWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceResubmitWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceResubmitWorkflowCall(namespace, name, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceResubmitWorkflow(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceResubmitWorkflowWithHttpInfo(namespace, name, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceResubmitWorkflowWithHttpInfo(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceResubmitWorkflowValidateBeforeCall(namespace, name, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceResubmitWorkflowAsync(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResubmitRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceResubmitWorkflowValidateBeforeCall(namespace, name, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceResumeWorkflowCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResumeRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowResumeRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/resume".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceResumeWorkflowValidateBeforeCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResumeRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceResumeWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceResumeWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceResumeWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceResumeWorkflowCall(namespace, name, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceResumeWorkflow(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResumeRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceResumeWorkflowWithHttpInfo(namespace, name, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceResumeWorkflowWithHttpInfo(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResumeRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceResumeWorkflowValidateBeforeCall(namespace, name, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceResumeWorkflowAsync(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowResumeRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceResumeWorkflowValidateBeforeCall(namespace, name, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceRetryWorkflowCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowRetryRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowRetryRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/retry".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceRetryWorkflowValidateBeforeCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowRetryRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceRetryWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceRetryWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceRetryWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceRetryWorkflowCall(namespace, name, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceRetryWorkflow(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowRetryRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceRetryWorkflowWithHttpInfo(namespace, name, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceRetryWorkflowWithHttpInfo(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowRetryRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceRetryWorkflowValidateBeforeCall(namespace, name, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceRetryWorkflowAsync(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowRetryRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceRetryWorkflowValidateBeforeCall(namespace, name, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceSetWorkflowCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSetRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowSetRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/set".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceSetWorkflowValidateBeforeCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSetRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceSetWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceSetWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceSetWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceSetWorkflowCall(namespace, name, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceSetWorkflow(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSetRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceSetWorkflowWithHttpInfo(namespace, name, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceSetWorkflowWithHttpInfo(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSetRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceSetWorkflowValidateBeforeCall(namespace, name, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceSetWorkflowAsync(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSetRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceSetWorkflowValidateBeforeCall(namespace, name, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceStopWorkflowCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowStopRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowStopRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/stop".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceStopWorkflowValidateBeforeCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowStopRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceStopWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceStopWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceStopWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceStopWorkflowCall(namespace, name, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceStopWorkflow(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowStopRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceStopWorkflowWithHttpInfo(namespace, name, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceStopWorkflowWithHttpInfo(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowStopRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceStopWorkflowValidateBeforeCall(namespace, name, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceStopWorkflowAsync(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowStopRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceStopWorkflowValidateBeforeCall(namespace, name, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceSubmitWorkflowCall(String namespace, IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/submit".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceSubmitWorkflowValidateBeforeCall(String namespace, IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceSubmitWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceSubmitWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceSubmitWorkflowCall(namespace, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceSubmitWorkflow(String namespace, IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceSubmitWorkflowWithHttpInfo(namespace, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceSubmitWorkflowWithHttpInfo(String namespace, IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceSubmitWorkflowValidateBeforeCall(namespace, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceSubmitWorkflowAsync(String namespace, IoArgoprojWorkflowV1alpha1WorkflowSubmitRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceSubmitWorkflowValidateBeforeCall(namespace, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceSuspendWorkflowCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/suspend".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceSuspendWorkflowValidateBeforeCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceSuspendWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceSuspendWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceSuspendWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceSuspendWorkflowCall(namespace, name, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceSuspendWorkflow(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceSuspendWorkflowWithHttpInfo(namespace, name, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceSuspendWorkflowWithHttpInfo(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceSuspendWorkflowValidateBeforeCall(namespace, name, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceSuspendWorkflowAsync(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowSuspendRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceSuspendWorkflowValidateBeforeCall(namespace, name, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceTerminateWorkflowCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest body, ApiCallback _callback) throws ApiException {
        IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest localVarPostBody = body;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/terminate".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceTerminateWorkflowValidateBeforeCall(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest body, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceTerminateWorkflow(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceTerminateWorkflow(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling workflowServiceTerminateWorkflow(Async)");
        }
        Call localVarCall = this.workflowServiceTerminateWorkflowCall(namespace, name, body, _callback);
        return localVarCall;
    }

    public IoArgoprojWorkflowV1alpha1Workflow workflowServiceTerminateWorkflow(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest body) throws ApiException {
        ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> localVarResp = this.workflowServiceTerminateWorkflowWithHttpInfo(namespace, name, body);
        return localVarResp.getData();
    }

    public ApiResponse<IoArgoprojWorkflowV1alpha1Workflow> workflowServiceTerminateWorkflowWithHttpInfo(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest body) throws ApiException {
        Call localVarCall = this.workflowServiceTerminateWorkflowValidateBeforeCall(namespace, name, body, null);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceTerminateWorkflowAsync(String namespace, String name, IoArgoprojWorkflowV1alpha1WorkflowTerminateRequest body, ApiCallback<IoArgoprojWorkflowV1alpha1Workflow> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceTerminateWorkflowValidateBeforeCall(namespace, name, body, _callback);
        Type localVarReturnType = new TypeToken<IoArgoprojWorkflowV1alpha1Workflow>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceWatchEventsCall(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/stream/events/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listOptionsLabelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.labelSelector", listOptionsLabelSelector));
        }
        if (listOptionsFieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.fieldSelector", listOptionsFieldSelector));
        }
        if (listOptionsWatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.watch", listOptionsWatch));
        }
        if (listOptionsAllowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.allowWatchBookmarks", listOptionsAllowWatchBookmarks));
        }
        if (listOptionsResourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.resourceVersion", listOptionsResourceVersion));
        }
        if (listOptionsResourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.resourceVersionMatch", listOptionsResourceVersionMatch));
        }
        if (listOptionsTimeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.timeoutSeconds", listOptionsTimeoutSeconds));
        }
        if (listOptionsLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.limit", listOptionsLimit));
        }
        if (listOptionsContinue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.continue", listOptionsContinue));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceWatchEventsValidateBeforeCall(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceWatchEvents(Async)");
        }
        Call localVarCall = this.workflowServiceWatchEventsCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, _callback);
        return localVarCall;
    }

    public StreamResultOfEvent workflowServiceWatchEvents(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue) throws ApiException {
        ApiResponse<StreamResultOfEvent> localVarResp = this.workflowServiceWatchEventsWithHttpInfo(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue);
        return localVarResp.getData();
    }

    public ApiResponse<StreamResultOfEvent> workflowServiceWatchEventsWithHttpInfo(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue) throws ApiException {
        Call localVarCall = this.workflowServiceWatchEventsValidateBeforeCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, null);
        Type localVarReturnType = new TypeToken<StreamResultOfEvent>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceWatchEventsAsync(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, ApiCallback<StreamResultOfEvent> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceWatchEventsValidateBeforeCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, _callback);
        Type localVarReturnType = new TypeToken<StreamResultOfEvent>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceWatchWorkflowsCall(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/workflow-events/{namespace}".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (listOptionsLabelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.labelSelector", listOptionsLabelSelector));
        }
        if (listOptionsFieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.fieldSelector", listOptionsFieldSelector));
        }
        if (listOptionsWatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.watch", listOptionsWatch));
        }
        if (listOptionsAllowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.allowWatchBookmarks", listOptionsAllowWatchBookmarks));
        }
        if (listOptionsResourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.resourceVersion", listOptionsResourceVersion));
        }
        if (listOptionsResourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.resourceVersionMatch", listOptionsResourceVersionMatch));
        }
        if (listOptionsTimeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.timeoutSeconds", listOptionsTimeoutSeconds));
        }
        if (listOptionsLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.limit", listOptionsLimit));
        }
        if (listOptionsContinue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listOptions.continue", listOptionsContinue));
        }
        if (fields != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fields", fields));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceWatchWorkflowsValidateBeforeCall(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceWatchWorkflows(Async)");
        }
        Call localVarCall = this.workflowServiceWatchWorkflowsCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields, _callback);
        return localVarCall;
    }

    public StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent workflowServiceWatchWorkflows(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields) throws ApiException {
        ApiResponse<StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent> localVarResp = this.workflowServiceWatchWorkflowsWithHttpInfo(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields);
        return localVarResp.getData();
    }

    public ApiResponse<StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent> workflowServiceWatchWorkflowsWithHttpInfo(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields) throws ApiException {
        Call localVarCall = this.workflowServiceWatchWorkflowsValidateBeforeCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields, null);
        Type localVarReturnType = new TypeToken<StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceWatchWorkflowsAsync(String namespace, String listOptionsLabelSelector, String listOptionsFieldSelector, Boolean listOptionsWatch, Boolean listOptionsAllowWatchBookmarks, String listOptionsResourceVersion, String listOptionsResourceVersionMatch, String listOptionsTimeoutSeconds, String listOptionsLimit, String listOptionsContinue, String fields, ApiCallback<StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceWatchWorkflowsValidateBeforeCall(namespace, listOptionsLabelSelector, listOptionsFieldSelector, listOptionsWatch, listOptionsAllowWatchBookmarks, listOptionsResourceVersion, listOptionsResourceVersionMatch, listOptionsTimeoutSeconds, listOptionsLimit, listOptionsContinue, fields, _callback);
        Type localVarReturnType = new TypeToken<StreamResultOfIoArgoprojWorkflowV1alpha1WorkflowWatchEvent>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call workflowServiceWorkflowLogsCall(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/workflows/{namespace}/{name}/log".replaceAll("\\{namespace\\}", this.localVarApiClient.escapeString(namespace.toString())).replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (podName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("podName", podName));
        }
        if (logOptionsContainer != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.container", logOptionsContainer));
        }
        if (logOptionsFollow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.follow", logOptionsFollow));
        }
        if (logOptionsPrevious != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.previous", logOptionsPrevious));
        }
        if (logOptionsSinceSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.sinceSeconds", logOptionsSinceSeconds));
        }
        if (logOptionsSinceTimeSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.sinceTime.seconds", logOptionsSinceTimeSeconds));
        }
        if (logOptionsSinceTimeNanos != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.sinceTime.nanos", logOptionsSinceTimeNanos));
        }
        if (logOptionsTimestamps != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.timestamps", logOptionsTimestamps));
        }
        if (logOptionsTailLines != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.tailLines", logOptionsTailLines));
        }
        if (logOptionsLimitBytes != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.limitBytes", logOptionsLimitBytes));
        }
        if (logOptionsInsecureSkipTLSVerifyBackend != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("logOptions.insecureSkipTLSVerifyBackend", logOptionsInsecureSkipTLSVerifyBackend));
        }
        if (grep != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("grep", grep));
        }
        if (selector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("selector", selector));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call workflowServiceWorkflowLogsValidateBeforeCall(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector, ApiCallback _callback) throws ApiException {
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling workflowServiceWorkflowLogs(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling workflowServiceWorkflowLogs(Async)");
        }
        Call localVarCall = this.workflowServiceWorkflowLogsCall(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector, _callback);
        return localVarCall;
    }

    public StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry workflowServiceWorkflowLogs(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector) throws ApiException {
        ApiResponse<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry> localVarResp = this.workflowServiceWorkflowLogsWithHttpInfo(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector);
        return localVarResp.getData();
    }

    public ApiResponse<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry> workflowServiceWorkflowLogsWithHttpInfo(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector) throws ApiException {
        Call localVarCall = this.workflowServiceWorkflowLogsValidateBeforeCall(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector, null);
        Type localVarReturnType = new TypeToken<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call workflowServiceWorkflowLogsAsync(String namespace, String name, String podName, String logOptionsContainer, Boolean logOptionsFollow, Boolean logOptionsPrevious, String logOptionsSinceSeconds, String logOptionsSinceTimeSeconds, Integer logOptionsSinceTimeNanos, Boolean logOptionsTimestamps, String logOptionsTailLines, String logOptionsLimitBytes, Boolean logOptionsInsecureSkipTLSVerifyBackend, String grep, String selector, ApiCallback<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry> _callback) throws ApiException {
        Call localVarCall = this.workflowServiceWorkflowLogsValidateBeforeCall(namespace, name, podName, logOptionsContainer, logOptionsFollow, logOptionsPrevious, logOptionsSinceSeconds, logOptionsSinceTimeSeconds, logOptionsSinceTimeNanos, logOptionsTimestamps, logOptionsTailLines, logOptionsLimitBytes, logOptionsInsecureSkipTLSVerifyBackend, grep, selector, _callback);
        Type localVarReturnType = new TypeToken<StreamResultOfIoArgoprojWorkflowV1alpha1LogEntry>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

