/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.xml;

import ch.toe.famix.Visitor;
import org.apache.log4j.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLIterator {
    private static final Logger LOG = Logger.getLogger(XMLIterator.class);
    private Visitor visitor;
    private boolean inclAttributeName = true;
    private boolean inclValues = false;

    public XMLIterator(boolean bl, boolean bl2) {
        this.inclAttributeName = bl;
        this.inclValues = bl2;
    }

    public void setVisitor(Visitor visitor) {
        this.visitor = visitor;
    }

    public void scanNodes(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                Text text = (Text)node;
                String string = text.getData().trim();
                if (string != null && string.length() > 0 && this.inclValues) {
                    this.visitor.visit((Object)node);
                    break;
                }
                return;
            }
            case 9: {
                if (node.getChildNodes().getLength() == 1) {
                    node = node.getFirstChild();
                }
            }
            case 1: {
                this.visitor.visit((Object)node);
                if (node.hasAttributes() && this.inclAttributeName) {
                    this.scanAttributes(node);
                }
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2 == null) {
                        LOG.debug((Object)("child not found for node: " + node.getNodeName() + "; children = " + nodeList.getLength()));
                    }
                    if (node2.getNodeType() == 2) continue;
                    this.scanNodes(node2);
                }
                break;
            }
            default: {
                this.visitor.visit((Object)node);
            }
        }
        this.visitor.endVisit(null);
    }

    private void scanAttributes(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            this.visitor.visit((Object)node2);
            this.visitor.endVisit(null);
        }
    }
}

