/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import simpack.util.tree.visitor.ast.Node;
import simpack.util.tree.visitor.ast.SourceCodeEntity;

public class JavaASTDeclarationTransformer
extends ASTVisitor {
    public static final int IDENTIFIER = 128;
    private Stack<Node> fStack = new Stack();

    public JavaASTDeclarationTransformer(Node node) {
        this.fStack.clear();
        this.fStack.push(node);
    }

    public boolean visit(Block block) {
        return true;
    }

    public void endVisit(Block block) {
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        this.visitList(96, fieldDeclaration.modifiers());
        fieldDeclaration.getType().accept((ASTVisitor)this);
        this.visitList(100, fieldDeclaration.fragments());
        return false;
    }

    public void endVisit(FieldDeclaration fieldDeclaration) {
        this.pop();
    }

    public boolean visit(Javadoc javadoc) {
        this.pushEmptyNode((ASTNode)javadoc);
        return true;
    }

    public void endVisit(Javadoc javadoc) {
        this.pop();
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.visitList(96, methodDeclaration.modifiers());
        if (methodDeclaration.getReturnType2() != null) {
            methodDeclaration.getReturnType2().accept((ASTVisitor)this);
        }
        this.visitList(93, methodDeclaration.typeParameters());
        this.visitList(104, methodDeclaration.parameters());
        this.visitList(107, methodDeclaration.thrownExceptions());
        return false;
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        this.pop();
    }

    public boolean visit(Modifier modifier) {
        this.pushValuedNode((ASTNode)modifier, modifier.getKeyword().toString());
        return false;
    }

    public void endVisit(Modifier modifier) {
        this.pop();
    }

    public boolean visit(ParameterizedType parameterizedType) {
        this.pushEmptyNode((ASTNode)parameterizedType);
        parameterizedType.getType().accept((ASTVisitor)this);
        this.visitList(93, parameterizedType.typeArguments());
        return false;
    }

    public void endVisit(ParameterizedType parameterizedType) {
        this.pop();
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.pushValuedNode((ASTNode)primitiveType, primitiveType.getPrimitiveTypeCode().toString());
        return false;
    }

    public void endVisit(PrimitiveType primitiveType) {
        this.pop();
    }

    public boolean visit(QualifiedType qualifiedType) {
        this.pushEmptyNode((ASTNode)qualifiedType);
        return true;
    }

    public void endVisit(QualifiedType qualifiedType) {
        this.pop();
    }

    public boolean visit(SimpleType simpleType) {
        this.pushValuedNode((ASTNode)simpleType, simpleType.getName().getFullyQualifiedName());
        return false;
    }

    public void endVisit(SimpleType simpleType) {
        this.pop();
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        boolean bl = this.getCurrentParent().getLabel() != 104;
        this.pushValuedNode((ASTNode)singleVariableDeclaration, singleVariableDeclaration.getName().getIdentifier());
        if (bl) {
            this.visitList(96, singleVariableDeclaration.modifiers());
        }
        singleVariableDeclaration.getType().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(SingleVariableDeclaration singleVariableDeclaration) {
        this.pop();
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        this.pushValuedNode((ASTNode)typeDeclaration, typeDeclaration.getName().getFullyQualifiedName());
        this.visitList(96, typeDeclaration.modifiers());
        this.visitList(93, typeDeclaration.typeParameters());
        if (typeDeclaration.getSuperclassType() != null) {
            typeDeclaration.getSuperclassType().accept((ASTVisitor)this);
        }
        this.visitList(97, typeDeclaration.superInterfaceTypes());
        return false;
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        this.pop();
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        return true;
    }

    public void endVisit(TypeDeclarationStatement typeDeclarationStatement) {
    }

    public boolean visit(TypeLiteral typeLiteral) {
        this.pushEmptyNode((ASTNode)typeLiteral);
        return true;
    }

    public void endVisit(TypeLiteral typeLiteral) {
        this.pop();
    }

    public boolean visit(TypeParameter typeParameter) {
        this.pushValuedNode((ASTNode)typeParameter, typeParameter.getName().getFullyQualifiedName());
        this.visitList(typeParameter.typeBounds());
        return false;
    }

    public void endVisit(TypeParameter typeParameter) {
        this.pop();
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        this.pushEmptyNode((ASTNode)variableDeclarationExpression);
        this.visitList(96, variableDeclarationExpression.modifiers());
        variableDeclarationExpression.getType().accept((ASTVisitor)this);
        this.visitList(100, variableDeclarationExpression.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationExpression variableDeclarationExpression) {
        this.pop();
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        this.pushValuedNode((ASTNode)variableDeclarationFragment, variableDeclarationFragment.getName().getFullyQualifiedName());
        return false;
    }

    public void endVisit(VariableDeclarationFragment variableDeclarationFragment) {
        this.pop();
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        this.pushEmptyNode((ASTNode)variableDeclarationStatement);
        this.visitList(96, variableDeclarationStatement.modifiers());
        variableDeclarationStatement.getType().accept((ASTVisitor)this);
        this.visitList(100, variableDeclarationStatement.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationStatement variableDeclarationStatement) {
        this.pop();
    }

    public boolean visit(WildcardType wildcardType) {
        String string = wildcardType.isUpperBound() ? "extends" : "super";
        this.pushValuedNode((ASTNode)wildcardType, string);
        return true;
    }

    public void endVisit(WildcardType wildcardType) {
        this.pop();
    }

    private void visitList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ASTNode)iterator.next()).accept((ASTVisitor)this);
        }
    }

    private void visitList(int n, List list) {
        this.pushLabel(n);
        if (!list.isEmpty()) {
            this.visitList(list);
        }
        this.pop();
    }

    private void pushLabel(int n) {
        this.push(n, "");
    }

    private void pushEmptyNode(ASTNode aSTNode) {
        this.push(aSTNode.getNodeType(), "");
    }

    private void pushValuedNode(ASTNode aSTNode, String string) {
        this.push(aSTNode.getNodeType(), string);
    }

    private void push(int n, String string) {
        SourceCodeEntity sourceCodeEntity = null;
        sourceCodeEntity = new SourceCodeEntity(string.trim(), n, 0);
        Node node = new Node(n, string.trim(), sourceCodeEntity);
        this.getCurrentParent().add(node);
        this.fStack.push(node);
    }

    private void pop() {
        this.fStack.pop();
    }

    private Node getCurrentParent() {
        return this.fStack.peek();
    }
}

