/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree.visitor.ast;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import simpack.api.ITreeNode;
import simpack.util.tree.TreeNode;

public class ASTFullTransformer
extends ASTVisitor {
    public static final int THEN_STATEMENT = 90;
    public static final int ELSE_STATEMENT = 91;
    public static final int ARRAY_DIMENSION = 92;
    public static final int TYPE_ARGUMENTS = 93;
    public static final int ARGUMENTS = 94;
    public static final int BODY = 95;
    public static final int MODIFIERS = 96;
    public static final int SUPER_INTERFACE_TYPES = 97;
    public static final int ENUM_CONSTANTS = 98;
    public static final int BODY_DECLARATIONS = 99;
    public static final int FRAGMENTS = 100;
    public static final int INITIALIZERS = 101;
    public static final int UPDATERS = 102;
    public static final int EXTENDED_OPERANDS = 103;
    public static final int PARAMETERS = 104;
    public static final int CATCH_CLAUSES = 105;
    public static final int FINALLY = 106;
    public static final int THROW = 107;
    public static final int IDENTIFIER = 128;
    private Stack<ITreeNode> fStack = new Stack();

    public ASTFullTransformer() {
        this.fStack.clear();
    }

    public ASTFullTransformer(ITreeNode iTreeNode) {
        this.fStack.clear();
        this.fStack.push(iTreeNode);
    }

    public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
        return false;
    }

    public void endVisit(AnnotationTypeDeclaration annotationTypeDeclaration) {
    }

    public boolean visit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
        return false;
    }

    public void endVisit(AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration) {
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.push(anonymousClassDeclaration);
        return true;
    }

    public void endVisit(AnonymousClassDeclaration anonymousClassDeclaration) {
        this.pop();
    }

    public boolean visit(ArrayAccess arrayAccess) {
        this.pushEmptyNode((ASTNode)arrayAccess);
        return true;
    }

    public void endVisit(ArrayAccess arrayAccess) {
        this.pop();
    }

    public boolean visit(ArrayCreation arrayCreation) {
        this.pushEmptyNode((ASTNode)arrayCreation);
        arrayCreation.getType().accept((ASTVisitor)this);
        if (arrayCreation.dimensions().isEmpty()) {
            arrayCreation.getInitializer().accept((ASTVisitor)this);
        } else {
            this.visitList(92, arrayCreation.dimensions());
        }
        return false;
    }

    public void endVisit(ArrayCreation arrayCreation) {
        this.pop();
    }

    public boolean visit(ArrayInitializer arrayInitializer) {
        this.pushEmptyNode((ASTNode)arrayInitializer);
        return true;
    }

    public void endVisit(ArrayInitializer arrayInitializer) {
        this.pop();
    }

    public boolean visit(ArrayType arrayType) {
        return true;
    }

    public void endVisit(ArrayType arrayType) {
    }

    public boolean visit(AssertStatement assertStatement) {
        this.pushEmptyNode((ASTNode)assertStatement);
        return true;
    }

    public void endVisit(AssertStatement assertStatement) {
        this.pop();
    }

    public boolean visit(Assignment assignment) {
        return false;
    }

    public void endVisit(Assignment assignment) {
    }

    public boolean visit(Block block) {
        return true;
    }

    public void endVisit(Block block) {
    }

    public boolean visit(BlockComment blockComment) {
        return false;
    }

    public void endVisit(BlockComment blockComment) {
    }

    public boolean visit(BooleanLiteral booleanLiteral) {
        this.pushValuedNode((ASTNode)booleanLiteral, String.valueOf(booleanLiteral.booleanValue()));
        return false;
    }

    public void endVisit(BooleanLiteral booleanLiteral) {
        this.pop();
    }

    public boolean visit(BreakStatement breakStatement) {
        String string = breakStatement.getLabel() != null ? breakStatement.getLabel().toString() : "";
        this.pushValuedNode((ASTNode)breakStatement, string);
        return false;
    }

    public void endVisit(BreakStatement breakStatement) {
        this.pop();
    }

    public boolean visit(CastExpression castExpression) {
        this.pushEmptyNode((ASTNode)castExpression);
        return false;
    }

    public void endVisit(CastExpression castExpression) {
        this.pop();
    }

    public boolean visit(CatchClause catchClause) {
        SimpleType simpleType = (SimpleType)catchClause.getException().getType();
        this.pushValuedNode((ASTNode)catchClause, simpleType.getName().getFullyQualifiedName());
        if (catchClause.getBody() != null) {
            catchClause.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(CatchClause catchClause) {
        this.pop();
    }

    public boolean visit(CharacterLiteral characterLiteral) {
        this.pushValuedNode((ASTNode)characterLiteral, String.valueOf(characterLiteral.charValue()));
        return false;
    }

    public void endVisit(CharacterLiteral characterLiteral) {
        this.pop();
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.pushEmptyNode((ASTNode)classInstanceCreation);
        if (classInstanceCreation.getExpression() != null) {
            classInstanceCreation.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(93, classInstanceCreation.typeArguments());
        classInstanceCreation.getType().accept((ASTVisitor)this);
        this.visitList(94, classInstanceCreation.arguments());
        if (classInstanceCreation.getAnonymousClassDeclaration() != null) {
            classInstanceCreation.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(ClassInstanceCreation classInstanceCreation) {
        this.pop();
    }

    public boolean visit(CompilationUnit compilationUnit) {
        this.pushEmptyNode((ASTNode)compilationUnit);
        return true;
    }

    public void endVisit(CompilationUnit compilationUnit) {
        this.pop();
    }

    public boolean visit(ConditionalExpression conditionalExpression) {
        this.pushEmptyNode((ASTNode)conditionalExpression);
        return true;
    }

    public void endVisit(ConditionalExpression conditionalExpression) {
        this.pop();
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        this.pushEmptyNode((ASTNode)constructorInvocation);
        this.visitList(93, constructorInvocation.typeArguments());
        this.visitList(94, constructorInvocation.arguments());
        return false;
    }

    public void endVisit(ConstructorInvocation constructorInvocation) {
        this.pop();
    }

    public boolean visit(ContinueStatement continueStatement) {
        String string = continueStatement.getLabel() != null ? continueStatement.getLabel().toString() : "";
        this.pushValuedNode((ASTNode)continueStatement, string);
        return false;
    }

    public void endVisit(ContinueStatement continueStatement) {
        this.pop();
    }

    public boolean visit(DoStatement doStatement) {
        this.pushEmptyNode((ASTNode)doStatement);
        doStatement.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        doStatement.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(DoStatement doStatement) {
        this.pop();
    }

    public boolean visit(EmptyStatement emptyStatement) {
        this.pushEmptyNode((ASTNode)emptyStatement);
        return false;
    }

    public void endVisit(EmptyStatement emptyStatement) {
        this.pop();
    }

    public boolean visit(EnhancedForStatement enhancedForStatement) {
        this.pushEmptyNode((ASTNode)enhancedForStatement);
        enhancedForStatement.getParameter().accept((ASTVisitor)this);
        enhancedForStatement.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        enhancedForStatement.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(EnhancedForStatement enhancedForStatement) {
        this.pop();
    }

    public boolean visit(EnumConstantDeclaration enumConstantDeclaration) {
        this.pushValuedNode((ASTNode)enumConstantDeclaration, enumConstantDeclaration.getName().getFullyQualifiedName());
        if (enumConstantDeclaration.getJavadoc() != null) {
            enumConstantDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        this.visitList(96, enumConstantDeclaration.modifiers());
        this.visitList(94, enumConstantDeclaration.arguments());
        if (enumConstantDeclaration.getAnonymousClassDeclaration() != null) {
            enumConstantDeclaration.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(EnumConstantDeclaration enumConstantDeclaration) {
        this.pop();
    }

    public boolean visit(EnumDeclaration enumDeclaration) {
        this.pushValuedNode((ASTNode)enumDeclaration, enumDeclaration.getName().getFullyQualifiedName());
        if (enumDeclaration.getJavadoc() != null) {
            enumDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        this.visitList(96, enumDeclaration.modifiers());
        this.visitList(97, enumDeclaration.superInterfaceTypes());
        this.visitList(98, enumDeclaration.enumConstants());
        this.visitList(99, enumDeclaration.bodyDeclarations());
        return false;
    }

    public void endVisit(EnumDeclaration enumDeclaration) {
        this.pop();
    }

    public boolean visit(ExpressionStatement expressionStatement) {
        return true;
    }

    public void endVisit(ExpressionStatement expressionStatement) {
    }

    public boolean visit(FieldAccess fieldAccess) {
        this.pushValuedNode((ASTNode)fieldAccess, fieldAccess.getName().getFullyQualifiedName());
        fieldAccess.getExpression().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(FieldAccess fieldAccess) {
        this.pop();
    }

    public boolean visit(FieldDeclaration fieldDeclaration) {
        this.pushEmptyNode((ASTNode)fieldDeclaration);
        return false;
    }

    public void endVisit(FieldDeclaration fieldDeclaration) {
        this.pop();
    }

    public boolean visit(ForStatement forStatement) {
        this.pushEmptyNode((ASTNode)forStatement);
        this.visitList(101, forStatement.initializers());
        if (forStatement.getExpression() != null) {
            forStatement.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(102, forStatement.updaters());
        this.pushLabel(95);
        forStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(ForStatement forStatement) {
        this.pop();
    }

    public boolean visit(IfStatement ifStatement) {
        ifStatement.getExpression().accept((ASTVisitor)this);
        if (ifStatement.getThenStatement() != null) {
            this.pushLabel(90);
            ifStatement.getThenStatement().accept((ASTVisitor)this);
            this.pop();
        }
        if (ifStatement.getElseStatement() != null) {
            this.pushLabel(91);
            ifStatement.getElseStatement().accept((ASTVisitor)this);
            this.pop();
        }
        return false;
    }

    public void endVisit(IfStatement ifStatement) {
        this.pop();
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        String string = importDeclaration.getName().getFullyQualifiedName();
        if (importDeclaration.isOnDemand()) {
            string = string + ".*";
        }
        this.pushValuedNode((ASTNode)importDeclaration, string);
        return false;
    }

    public void endVisit(ImportDeclaration importDeclaration) {
        this.pop();
    }

    public boolean visit(InfixExpression infixExpression) {
        this.pushValuedNode((ASTNode)infixExpression, infixExpression.getOperator().toString());
        infixExpression.getLeftOperand().accept((ASTVisitor)this);
        infixExpression.getRightOperand().accept((ASTVisitor)this);
        this.visitList(103, infixExpression.extendedOperands());
        return false;
    }

    public void endVisit(InfixExpression infixExpression) {
        this.pop();
    }

    public boolean visit(Initializer initializer) {
        this.pushEmptyNode((ASTNode)initializer);
        if (initializer.getJavadoc() != null) {
            initializer.getJavadoc().accept((ASTVisitor)this);
        }
        if (initializer.getBody() != null) {
            this.pushLabel(95);
            initializer.getBody().accept((ASTVisitor)this);
            this.pop();
        }
        return false;
    }

    public void endVisit(Initializer initializer) {
        this.pop();
    }

    public boolean visit(InstanceofExpression instanceofExpression) {
        this.pushEmptyNode((ASTNode)instanceofExpression);
        return true;
    }

    public void endVisit(InstanceofExpression instanceofExpression) {
        this.pop();
    }

    public boolean visit(Javadoc javadoc) {
        return false;
    }

    public void endVisit(Javadoc javadoc) {
    }

    public boolean visit(LabeledStatement labeledStatement) {
        this.pushValuedNode((ASTNode)labeledStatement, labeledStatement.getLabel().getFullyQualifiedName());
        labeledStatement.getBody().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(LabeledStatement labeledStatement) {
        this.pop();
    }

    public boolean visit(LineComment lineComment) {
        return false;
    }

    public void endVisit(LineComment lineComment) {
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        return false;
    }

    public void endVisit(MarkerAnnotation markerAnnotation) {
    }

    public boolean visit(MemberRef memberRef) {
        return false;
    }

    public void endVisit(MemberRef memberRef) {
    }

    public boolean visit(MemberValuePair memberValuePair) {
        return false;
    }

    public void endVisit(MemberValuePair memberValuePair) {
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.pushValuedNode((ASTNode)methodDeclaration, methodDeclaration.getName().getFullyQualifiedName());
        if (methodDeclaration.getReturnType2() != null) {
            methodDeclaration.getReturnType2().accept((ASTVisitor)this);
        }
        this.visitList(93, methodDeclaration.typeParameters());
        this.visitList(104, methodDeclaration.parameters());
        if (methodDeclaration.getBody() != null) {
            methodDeclaration.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(MethodDeclaration methodDeclaration) {
        this.pop();
    }

    public boolean visit(MethodInvocation methodInvocation) {
        this.pushValuedNode((ASTNode)methodInvocation, methodInvocation.getName().getFullyQualifiedName());
        if (methodInvocation.getExpression() != null) {
            methodInvocation.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(93, methodInvocation.typeArguments());
        this.visitList(94, methodInvocation.arguments());
        return false;
    }

    public void endVisit(MethodInvocation methodInvocation) {
        this.pop();
    }

    public boolean visit(MethodRef methodRef) {
        return false;
    }

    public void endVisit(MethodRef methodRef) {
    }

    public boolean visit(MethodRefParameter methodRefParameter) {
        return false;
    }

    public void endVisit(MethodRefParameter methodRefParameter) {
    }

    public boolean visit(Modifier modifier) {
        return false;
    }

    public void endVisit(Modifier modifier) {
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        return false;
    }

    public void endVisit(NormalAnnotation normalAnnotation) {
    }

    public boolean visit(NullLiteral nullLiteral) {
        return false;
    }

    public void endVisit(NullLiteral nullLiteral) {
    }

    public boolean visit(NumberLiteral numberLiteral) {
        return false;
    }

    public void endVisit(NumberLiteral numberLiteral) {
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        this.pushValuedNode((ASTNode)packageDeclaration, packageDeclaration.getName().getFullyQualifiedName());
        if (packageDeclaration.getJavadoc() != null) {
            packageDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(PackageDeclaration packageDeclaration) {
        this.pop();
    }

    public boolean visit(ParameterizedType parameterizedType) {
        this.pushEmptyNode((ASTNode)parameterizedType);
        parameterizedType.getType().accept((ASTVisitor)this);
        this.visitList(93, parameterizedType.typeArguments());
        return false;
    }

    public void endVisit(ParameterizedType parameterizedType) {
        this.pop();
    }

    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
        return true;
    }

    public void endVisit(ParenthesizedExpression parenthesizedExpression) {
    }

    public boolean visit(PostfixExpression postfixExpression) {
        this.pushValuedNode((ASTNode)postfixExpression, postfixExpression.getOperator().toString());
        return true;
    }

    public void endVisit(PostfixExpression postfixExpression) {
        this.pop();
    }

    public boolean visit(PrefixExpression prefixExpression) {
        this.pushValuedNode((ASTNode)prefixExpression, prefixExpression.getOperator().toString());
        return true;
    }

    public void endVisit(PrefixExpression prefixExpression) {
        this.pop();
    }

    public boolean visit(PrimitiveType primitiveType) {
        this.pushValuedNode((ASTNode)primitiveType, primitiveType.getPrimitiveTypeCode().toString());
        return false;
    }

    public void endVisit(PrimitiveType primitiveType) {
        this.pop();
    }

    public boolean visit(QualifiedName qualifiedName) {
        this.pushEmptyNode((ASTNode)qualifiedName);
        return true;
    }

    public void endVisit(QualifiedName qualifiedName) {
        this.pop();
    }

    public boolean visit(QualifiedType qualifiedType) {
        this.pushEmptyNode((ASTNode)qualifiedType);
        return true;
    }

    public void endVisit(QualifiedType qualifiedType) {
        this.pop();
    }

    public boolean visit(ReturnStatement returnStatement) {
        this.pushEmptyNode((ASTNode)returnStatement);
        return true;
    }

    public void endVisit(ReturnStatement returnStatement) {
        this.pop();
    }

    public boolean visit(SimpleName simpleName) {
        this.pushValuedNode((ASTNode)simpleName, simpleName.getIdentifier());
        return false;
    }

    public void endVisit(SimpleName simpleName) {
        this.pop();
    }

    public boolean visit(SimpleType simpleType) {
        this.pushValuedNode((ASTNode)simpleType, simpleType.getName().getFullyQualifiedName());
        return false;
    }

    public void endVisit(SimpleType simpleType) {
        this.pop();
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        return false;
    }

    public void endVisit(SingleMemberAnnotation singleMemberAnnotation) {
        this.pop();
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.pushValuedNode((ASTNode)singleVariableDeclaration, singleVariableDeclaration.getName().getIdentifier());
        this.visitList(96, singleVariableDeclaration.modifiers());
        singleVariableDeclaration.getType().accept((ASTVisitor)this);
        if (singleVariableDeclaration.getInitializer() != null) {
            singleVariableDeclaration.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(SingleVariableDeclaration singleVariableDeclaration) {
        this.pop();
    }

    public boolean visit(StringLiteral stringLiteral) {
        this.pushValuedNode((ASTNode)stringLiteral, stringLiteral.getLiteralValue());
        return false;
    }

    public void endVisit(StringLiteral stringLiteral) {
        this.pop();
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        this.pushEmptyNode((ASTNode)superConstructorInvocation);
        if (superConstructorInvocation.getExpression() != null) {
            superConstructorInvocation.getExpression().accept((ASTVisitor)this);
        }
        this.visitList(93, superConstructorInvocation.typeArguments());
        this.visitList(94, superConstructorInvocation.arguments());
        return false;
    }

    public void endVisit(SuperConstructorInvocation superConstructorInvocation) {
        this.pop();
    }

    public boolean visit(SuperFieldAccess superFieldAccess) {
        this.pushValuedNode((ASTNode)superFieldAccess, superFieldAccess.getName().getFullyQualifiedName());
        superFieldAccess.getQualifier().accept((ASTVisitor)this);
        return false;
    }

    public void endVisit(SuperFieldAccess superFieldAccess) {
        this.pop();
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        this.pushValuedNode((ASTNode)superMethodInvocation, superMethodInvocation.getName().getFullyQualifiedName());
        superMethodInvocation.getQualifier().accept((ASTVisitor)this);
        this.visitList(93, superMethodInvocation.typeArguments());
        this.visitList(94, superMethodInvocation.arguments());
        return false;
    }

    public void endVisit(SuperMethodInvocation superMethodInvocation) {
        this.pop();
    }

    public boolean visit(SwitchCase switchCase) {
        this.pushEmptyNode((ASTNode)switchCase);
        return true;
    }

    public void endVisit(SwitchCase switchCase) {
        this.pop();
    }

    public boolean visit(SwitchStatement switchStatement) {
        this.pushEmptyNode((ASTNode)switchStatement);
        switchStatement.getExpression().accept((ASTVisitor)this);
        this.visitList(95, switchStatement.statements());
        return false;
    }

    public void endVisit(SwitchStatement switchStatement) {
        this.pop();
    }

    public boolean visit(SynchronizedStatement synchronizedStatement) {
        this.pushEmptyNode((ASTNode)synchronizedStatement);
        synchronizedStatement.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        synchronizedStatement.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(SynchronizedStatement synchronizedStatement) {
        this.pop();
    }

    public boolean visit(TagElement tagElement) {
        return false;
    }

    public void endVisit(TagElement tagElement) {
    }

    public boolean visit(TextElement textElement) {
        this.pushValuedNode((ASTNode)textElement, textElement.getText());
        return false;
    }

    public void endVisit(TextElement textElement) {
        this.pop();
    }

    public boolean visit(ThisExpression thisExpression) {
        this.pushEmptyNode((ASTNode)thisExpression);
        return true;
    }

    public void endVisit(ThisExpression thisExpression) {
        this.pop();
    }

    public boolean visit(ThrowStatement throwStatement) {
        this.pushEmptyNode((ASTNode)throwStatement);
        return true;
    }

    public void endVisit(ThrowStatement throwStatement) {
        this.pop();
    }

    public boolean visit(TryStatement tryStatement) {
        this.pushEmptyNode((ASTNode)tryStatement);
        this.pushLabel(95);
        tryStatement.getBody().accept((ASTVisitor)this);
        this.pop();
        this.visitList(105, tryStatement.catchClauses());
        this.pushLabel(106);
        tryStatement.getFinally();
        this.pop();
        return false;
    }

    public void endVisit(TryStatement tryStatement) {
        this.pop();
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        this.pushValuedNode((ASTNode)typeDeclaration, typeDeclaration.getName().getFullyQualifiedName());
        if (typeDeclaration.getJavadoc() != null) {
            typeDeclaration.getJavadoc().accept((ASTVisitor)this);
        }
        this.visitList(96, typeDeclaration.modifiers());
        this.visitList(93, typeDeclaration.typeParameters());
        if (typeDeclaration.getSuperclassType() != null) {
            typeDeclaration.getSuperclassType().accept((ASTVisitor)this);
        }
        this.visitList(97, typeDeclaration.superInterfaceTypes());
        this.visitList(99, typeDeclaration.bodyDeclarations());
        return false;
    }

    public void endVisit(TypeDeclaration typeDeclaration) {
        this.pop();
    }

    public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
        return true;
    }

    public void endVisit(TypeDeclarationStatement typeDeclarationStatement) {
    }

    public boolean visit(TypeLiteral typeLiteral) {
        this.pushEmptyNode((ASTNode)typeLiteral);
        return true;
    }

    public void endVisit(TypeLiteral typeLiteral) {
        this.pop();
    }

    public boolean visit(TypeParameter typeParameter) {
        this.pushValuedNode((ASTNode)typeParameter, typeParameter.getName().getFullyQualifiedName());
        this.visitList(typeParameter.typeBounds());
        return false;
    }

    public void endVisit(TypeParameter typeParameter) {
        this.pop();
    }

    public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
        this.pushEmptyNode((ASTNode)variableDeclarationExpression);
        this.visitList(96, variableDeclarationExpression.modifiers());
        variableDeclarationExpression.getType().accept((ASTVisitor)this);
        this.visitList(100, variableDeclarationExpression.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationExpression variableDeclarationExpression) {
        this.pop();
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        this.pushValuedNode((ASTNode)variableDeclarationFragment, variableDeclarationFragment.getName().getFullyQualifiedName());
        if (variableDeclarationFragment.getInitializer() != null) {
            variableDeclarationFragment.getInitializer().accept((ASTVisitor)this);
        }
        return false;
    }

    public void endVisit(VariableDeclarationFragment variableDeclarationFragment) {
        this.pop();
    }

    public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
        this.pushEmptyNode((ASTNode)variableDeclarationStatement);
        this.visitList(96, variableDeclarationStatement.modifiers());
        variableDeclarationStatement.getType().accept((ASTVisitor)this);
        this.visitList(100, variableDeclarationStatement.fragments());
        return false;
    }

    public void endVisit(VariableDeclarationStatement variableDeclarationStatement) {
        this.pop();
    }

    public boolean visit(WhileStatement whileStatement) {
        this.pushEmptyNode((ASTNode)whileStatement);
        whileStatement.getExpression().accept((ASTVisitor)this);
        this.pushLabel(95);
        whileStatement.getBody().accept((ASTVisitor)this);
        this.pop();
        return false;
    }

    public void endVisit(WhileStatement whileStatement) {
        this.pop();
    }

    public boolean visit(WildcardType wildcardType) {
        String string = wildcardType.isUpperBound() ? "extends" : "super";
        this.pushValuedNode((ASTNode)wildcardType, string);
        return true;
    }

    public void endVisit(WildcardType wildcardType) {
        this.pop();
    }

    private void visitList(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((ASTNode)iterator.next()).accept((ASTVisitor)this);
        }
    }

    private void visitList(int n, List list) {
        this.pushLabel(n);
        if (!list.isEmpty()) {
            this.visitList(list);
        }
        this.pop();
    }

    private void pushLabel(int n) {
        this.push(new Integer(n));
    }

    private void pushEmptyNode(ASTNode aSTNode) {
        this.push(aSTNode);
    }

    private void pushValuedNode(ASTNode aSTNode, String string) {
        this.push(aSTNode);
    }

    private void push(Object object) {
        TreeNode treeNode = new TreeNode(object);
        if (!this.fStack.isEmpty()) {
            this.getCurrentParent().add(treeNode);
        }
        this.fStack.push(treeNode);
    }

    private void pop() {
        this.fStack.pop();
    }

    private ITreeNode getCurrentParent() {
        return this.fStack.peek();
    }
}

