/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeUtil {
    public static int calculateSize(ITreeNode iTreeNode) {
        int n = 1;
        Enumeration<? extends TreeNode> enumeration = iTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ITreeNode iTreeNode2 = (ITreeNode)enumeration.nextElement();
            n += TreeUtil.calculateSize(iTreeNode2);
        }
        return n;
    }

    public static List<ITreeNode> enumerationToList(Enumeration enumeration) throws InvalidElementException {
        LinkedList<ITreeNode> linkedList = new LinkedList<ITreeNode>();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof ITreeNode) {
                linkedList.add((ITreeNode)e);
                continue;
            }
            throw new InvalidElementException("Unexpected child type in Tree while converting enumeration.");
        }
        return linkedList;
    }

    public static Double getSimilarity4to1(ITreeNode iTreeNode, ITreeNode iTreeNode2, ITreeNode iTreeNode3) {
        Double d = new Double(TreeUtil.calculateSize(iTreeNode2));
        Double d2 = new Double(TreeUtil.calculateSize(iTreeNode));
        Double d3 = new Double(TreeUtil.calculateSize(iTreeNode3));
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        return (4.0 * (d3 / d2) + d3 / d) / 5.0;
    }

    public static Double getSimilarity1to1(ITreeNode iTreeNode, ITreeNode iTreeNode2, ITreeNode iTreeNode3) {
        Double d = new Double(TreeUtil.calculateSize(iTreeNode2));
        Double d2 = new Double(TreeUtil.calculateSize(iTreeNode));
        Double d3 = new Double(TreeUtil.calculateSize(iTreeNode3));
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        return 2.0 * d3 / (d2 + d);
    }

    public static Double getSimilarityMatchedWeightened(ITreeNode iTreeNode, ITreeNode iTreeNode2, ITreeNode iTreeNode3) {
        Double d = new Double(TreeUtil.calculateSize(iTreeNode2));
        Double d2 = new Double(TreeUtil.calculateSize(iTreeNode));
        Double d3 = new Double(TreeUtil.calculateSize(iTreeNode3));
        Double d4 = d3 / d2;
        Double d5 = d3 / d;
        if (d5 > 0.8) {
            return (2.0 * d4 + d5) / 3.0;
        }
        if (d5 < 0.2) {
            return (d4 + 2.0 * d5) / 3.0;
        }
        return (d4 + d5) / 2.0;
    }
}

