/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.tree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeNode;
import simpack.api.impl.AbstractCalculator;
import simpack.exception.InvalidElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalenceClassCalculator
extends AbstractCalculator {
    private ITreeNode tree1;
    private List<ITreeNode> list1 = null;
    private ITreeNode tree2;
    private List<ITreeNode> list2 = null;
    private boolean ordered;
    private boolean labeled;
    private LinkedHashMap<LinkedList<Integer>, Integer> globalCodes = new LinkedHashMap();
    private int currentMaxEquivalence = 1;
    private LinkedHashMap<ITreeNode, Integer> code1 = new LinkedHashMap();
    private LinkedHashMap<ITreeNode, Integer> code2 = new LinkedHashMap();

    public EquivalenceClassCalculator(ITreeNode iTreeNode, List<ITreeNode> list, ITreeNode iTreeNode2, List<ITreeNode> list2) throws NullPointerException, InvalidElementException {
        this(iTreeNode, list, iTreeNode2, list2, false, false);
    }

    public EquivalenceClassCalculator(ITreeNode iTreeNode, List<ITreeNode> list, ITreeNode iTreeNode2, List<ITreeNode> list2, boolean bl) throws NullPointerException, InvalidElementException {
        this(iTreeNode, list, iTreeNode2, list2, bl, false);
    }

    public EquivalenceClassCalculator(ITreeNode iTreeNode, List<ITreeNode> list, ITreeNode iTreeNode2, List<ITreeNode> list2, boolean bl, boolean bl2) throws NullPointerException, InvalidElementException {
        if (iTreeNode == null || iTreeNode2 == null || list == null || list2 == null) {
            throw new NullPointerException();
        }
        this.ordered = bl;
        this.labeled = bl2;
        this.tree1 = iTreeNode;
        this.list1 = list;
        this.tree2 = iTreeNode2;
        this.list2 = list2;
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        try {
            this.calculateEquivalenceClass(this.list1, this.code1);
            this.calculateEquivalenceClass(this.list2, this.code2);
        }
        catch (InvalidElementException invalidElementException) {
            return false;
        }
        this.setCalculated(true);
        return true;
    }

    private void calculateEquivalenceClass(List<ITreeNode> list, LinkedHashMap<ITreeNode, Integer> linkedHashMap) throws InvalidElementException {
        ListIterator<ITreeNode> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ITreeNode iTreeNode = listIterator.next();
            if (iTreeNode.isLeaf()) {
                linkedHashMap.put(iTreeNode, 1);
                continue;
            }
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            Enumeration<? extends TreeNode> enumeration = iTreeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode = enumeration.nextElement();
                if (treeNode instanceof ITreeNode) {
                    ITreeNode iTreeNode2 = (ITreeNode)treeNode;
                    linkedList.add(linkedHashMap.get(iTreeNode2));
                    continue;
                }
                throw new InvalidElementException("Unexpected child type in Tree while calculating child codes.");
            }
            if (!this.ordered) {
                Collections.sort(linkedList);
            }
            if (this.labeled) {
                // empty if block
            }
            if (this.globalCodes.containsKey(linkedList)) {
                linkedHashMap.put(iTreeNode, this.globalCodes.get(linkedList));
                continue;
            }
            this.globalCodes.put(linkedList, ++this.currentMaxEquivalence);
            linkedHashMap.put(iTreeNode, this.currentMaxEquivalence);
        }
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassesTree1() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.code1;
    }

    public LinkedHashMap<ITreeNode, Integer> getEquivalenceClassesTree2() throws NullPointerException {
        if (!this.isCalculated()) {
            throw new NullPointerException("Instance did not sucessfully calculate!");
        }
        return this.code2;
    }

    public ITreeNode getTree1() {
        return this.tree1;
    }

    public ITreeNode getTree2() {
        return this.tree2;
    }
}

