/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.matrix;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class ReadAndWriteObject {
    static Logger logger = Logger.getLogger(ReadAndWriteObject.class);
    private long before;
    private long after;

    public Object read(String string) {
        logger.debug((Object)("Reading " + string));
        this.before = System.currentTimeMillis();
        Object object = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            this.after = System.currentTimeMillis();
            logger.debug((Object)(string + " read in " + (this.after - this.before) / 1000L + " seconds.\n"));
        }
        catch (IOException iOException) {
            System.out.println("Error while trying to read in " + string);
            System.out.println(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Error while trying to read in " + string);
            System.out.println(classNotFoundException.getMessage());
        }
        return object;
    }

    public void write(Object object, String string) {
        logger.debug((Object)("Writing into " + string));
        this.before = System.currentTimeMillis();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error while trying to write in " + string);
            System.out.println(iOException.getMessage());
        }
        this.after = System.currentTimeMillis();
        logger.debug((Object)("Object written in " + string + " in " + (this.after - this.before) / 1000L + " seconds.\n"));
    }
}

