/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.matrix;

import cern.colt.matrix.DoubleMatrix2D;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;

public class ReadAndWriteMatrix {
    static Logger logger = Logger.getLogger(ReadAndWriteMatrix.class);
    private long before;
    private long after;

    public DoubleMatrix2D read(String string) {
        logger.debug((Object)("Reading " + string));
        this.before = System.currentTimeMillis();
        DoubleMatrix2D doubleMatrix2D = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            doubleMatrix2D = (DoubleMatrix2D)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
            this.after = System.currentTimeMillis();
            logger.debug((Object)("Matrix read in " + (this.after - this.before) / 1000L + " seconds.\n"));
        }
        catch (IOException iOException) {
            System.out.println("Error while trying to read in " + string);
            System.out.println(iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Error while trying to read in " + string);
            System.out.println(classNotFoundException.getMessage());
        }
        return doubleMatrix2D;
    }

    public void write(DoubleMatrix2D doubleMatrix2D, String string) {
        logger.debug((Object)("Writing into " + string));
        this.before = System.currentTimeMillis();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(doubleMatrix2D);
            objectOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error while trying to write in " + string);
            System.out.println(iOException.getMessage());
        }
        this.after = System.currentTimeMillis();
        logger.debug((Object)("matrix written in " + string + " in " + (this.after - this.before) / 1000L + " seconds.\n"));
    }
}

