/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.matrix;

import java.io.Serializable;
import simpack.util.matrix.OptimizedMatrix1D;

public class OptimizedMatrix2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final OptimizedMatrix1D[] rows;
    private final OptimizedMatrix1D[] cols;
    private final int countRows;
    private final int countCols;

    public OptimizedMatrix2D(int n, int n2) {
        OptimizedMatrix1D optimizedMatrix1D;
        int n3;
        this.rows = new OptimizedMatrix1D[n];
        this.cols = new OptimizedMatrix1D[n2];
        for (n3 = 0; n3 < n; ++n3) {
            this.rows[n3] = optimizedMatrix1D = new OptimizedMatrix1D(n2);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.cols[n3] = optimizedMatrix1D = new OptimizedMatrix1D(n);
        }
        this.countRows = n;
        this.countCols = n2;
    }

    public void setQuick(int n, int n2, double d) {
        OptimizedMatrix1D optimizedMatrix1D = this.cols[n2];
        optimizedMatrix1D.setQuick(n, d);
        OptimizedMatrix1D optimizedMatrix1D2 = this.rows[n];
        optimizedMatrix1D2.setQuick(n2, d);
    }

    public double getQuick(int n, int n2) {
        OptimizedMatrix1D optimizedMatrix1D = this.rows[n];
        return optimizedMatrix1D.getQuick(n2);
    }

    public int rows() {
        return this.countRows;
    }

    public int columns() {
        return this.countCols;
    }

    public OptimizedMatrix1D viewColumn(int n) {
        return this.cols[n];
    }

    public OptimizedMatrix1D viewRow(int n) {
        return this.rows[n];
    }

    public void trim() {
        int n;
        for (n = 0; n < this.countRows; ++n) {
            this.rows[n].trim();
        }
        for (n = 0; n < this.countCols; ++n) {
            this.cols[n].trim();
        }
    }
}

