/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.graph;

import java.io.Serializable;
import java.util.TreeSet;
import simpack.api.IGraphNode;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphNode
implements IGraphNode,
Serializable,
Comparable<GraphNode> {
    private static final long serialVersionUID = -7149340901405017775L;
    protected Object userObject;
    protected TreeSet<IGraphNode> predecessorSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected TreeSet<IGraphNode> successorSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected TreeSet<IGraphNode> adjacentSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
    protected boolean isGroup = false;
    protected int inDegree = 0;
    protected int outDegree = 0;
    private boolean hasGroup = false;

    public GraphNode() {
    }

    public GraphNode(Object object) {
        this.userObject = object;
    }

    @Override
    public void setHasGroup() {
        this.hasGroup = true;
    }

    @Override
    public boolean getHasGroup() {
        return this.hasGroup;
    }

    @Override
    public boolean getIsGroup() {
        return false;
    }

    @Override
    public TreeSet<IGraphNode> getGroupNodes() {
        return null;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this.userObject = object;
    }

    @Override
    public TreeSet<IGraphNode> getPredecessorSet() {
        return this.predecessorSet;
    }

    @Override
    public TreeSet<IGraphNode> getSuccessorSet() {
        return this.successorSet;
    }

    @Override
    public TreeSet<IGraphNode> getAdjacentSet() {
        return this.adjacentSet;
    }

    @Override
    public void addPredecessor(IGraphNode iGraphNode) {
        this.predecessorSet.add(iGraphNode);
        this.adjacentSet.add(iGraphNode);
        ++this.inDegree;
    }

    @Override
    public void addSuccessor(IGraphNode iGraphNode) {
        this.successorSet.add(iGraphNode);
        this.adjacentSet.add(iGraphNode);
        ++this.outDegree;
    }

    @Override
    public Integer getInDegree() {
        return this.inDegree;
    }

    @Override
    public Integer getOutDegree() {
        return this.outDegree;
    }

    @Override
    public String getLabel() {
        return this.toString();
    }

    @Override
    public int getGroupSize() {
        return 0;
    }

    @Override
    public String toString() {
        return this.userObject.toString();
    }

    public boolean equals(Object object) {
        GraphNode graphNode = (GraphNode)object;
        return graphNode.userObject.equals(this.userObject);
    }

    @Override
    public int compareTo(GraphNode graphNode) {
        return this.getUserObject().toString().compareTo(graphNode.getUserObject().toString());
    }
}

