/*
 * Decompiled with CFR 0.152.
 */
package simpack.util.corpus;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Indexer {
    public static Logger logger = Logger.getLogger(Indexer.class);
    public static Analyzer DEFAULT_ANALYZER = new SnowballAnalyzer("Porter", StopAnalyzer.ENGLISH_STOP_WORDS);
    public static final String DEFAULT_DOCUMENT_CONTENTS_FIELD_NAME = "contents";
    public static final String DEFAULT_DOCUMENT_TITLE_FIELD_NAME = "title";
    public static final String DEFAULT_DOCUMENT_URL_FIELD_NAME = "url";
    public static final String[] DEFAULT_FIELD_NAMES = new String[]{"contents"};

    public static void generateIndex(String string, String string2) {
        try {
            FSDirectory fSDirectory = FSDirectory.getDirectory((String)string, (boolean)true);
            IndexWriter indexWriter = new IndexWriter((Directory)fSDirectory, DEFAULT_ANALYZER, true);
            Indexer.indexDirectory(indexWriter, new File(string2));
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void indexDirectory(IndexWriter indexWriter, File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                Indexer.indexDirectory(indexWriter, file2);
                continue;
            }
            Indexer.indexFile(indexWriter, file2);
        }
    }

    private static void indexFile(IndexWriter indexWriter, File file) {
        try {
            String string = file.getName();
            Document document = new Document();
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            string2 = bufferedReader.readLine();
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + " " + string3;
            }
            bufferedReader.close();
            document.add(new Field(DEFAULT_DOCUMENT_CONTENTS_FIELD_NAME, string2, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.YES));
            document.add(new Field(DEFAULT_DOCUMENT_TITLE_FIELD_NAME, string, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            document.add(new Field(DEFAULT_DOCUMENT_URL_FIELD_NAME, file.getAbsolutePath(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
            logger.info((Object)("Indexing document " + string));
            indexWriter.addDocument(document);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Indexer.generateIndex("data/index", "data/corpus");
    }
}

