/*
 * Decompiled with CFR 0.152.
 */
package simpack.util;

import simpack.exception.InvalidVectorSizeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector<E extends Number>
extends java.util.Vector<E> {
    private static final long serialVersionUID = -6016841594387442712L;

    public Vector() {
    }

    public Vector(int n) {
        super(n);
    }

    public Vector(E[] EArray) {
        this(EArray.length);
        for (E e : EArray) {
            this.add(e);
        }
    }

    public double getDotProduct(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        if (this.size() != vector.size()) {
            throw new InvalidVectorSizeException();
        }
        int n = 0;
        double d = 0.0;
        for (Number number : vector) {
            d += number.doubleValue() * ((Number)this.elementAt(n++)).doubleValue();
        }
        return d;
    }

    public Vector<? extends Number> getVectorAddition(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        if (this.size() != vector.size()) {
            throw new InvalidVectorSizeException();
        }
        int n = 0;
        Vector<Double> vector2 = new Vector<Double>(this.size());
        for (Number number : this) {
            Double d = new Double(number.doubleValue() + ((Number)vector.elementAt(n)).doubleValue());
            vector2.add(d);
        }
        return vector2;
    }

    public double getMinkowskiDistance(Vector<? extends Number> vector, double d) throws InvalidVectorSizeException {
        if (this.size() != vector.size()) {
            throw new InvalidVectorSizeException();
        }
        int n = 0;
        double d2 = 0.0;
        for (Number number : this) {
            double d3 = Math.abs(number.doubleValue() - ((Number)vector.elementAt(n++)).doubleValue());
            d2 += Math.pow(d3, d);
        }
        return Math.pow(d2, 1.0 / d);
    }

    public double getEuclideanDistance(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        return this.getMinkowskiDistance(vector, 2.0);
    }

    public double getManhattanDistance(Vector<? extends Number> vector) throws InvalidVectorSizeException {
        return this.getMinkowskiDistance(vector, 1.0);
    }

    public double getNorm(double d) {
        double d2 = 0.0;
        for (Number number : this) {
            d2 += Math.pow(number.doubleValue(), d);
        }
        d2 = Math.pow(d2, 1.0 / d);
        return d2;
    }

    public double getMean() {
        double d = 0.0;
        for (Number number : this) {
            d += number.doubleValue();
        }
        return d / (double)this.size();
    }

    public double getVariance() {
        double d = 0.0;
        double d2 = this.getMean();
        for (Number number : this) {
            d += Math.pow(number.doubleValue() - d2, 2.0);
        }
        return d / (double)this.size();
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public Vector<? extends Number> convertToZScore() {
        double d = this.getMean();
        double d2 = this.getStandardDeviation();
        System.out.println(d + " " + d2);
        Vector<Double> vector = new Vector<Double>(this.size());
        for (Number number : this) {
            vector.add((number.doubleValue() - d) / d2);
        }
        return vector;
    }
}

