/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.weightingscheme;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import java.util.ArrayList;
import junit.framework.TestCase;
import simpack.measure.weightingscheme.StringTFIDF;
import simpack.util.corpus.StringUtils;

public class StringTFIDFTestOnlyCorpusInitialization
extends TestCase {
    private ArrayList<StringWrapper> corpus;
    private String str1 = "Auditory scene analysis based on time-frequency integration of shared FM and AM (II): Optimum time-domain integration and stream sound reconstruction.";
    private String str2 = "Auditory scene analysis based on time-frequency integration of shared FM and AM (I): Lagrange differential features and frequency-axis integration.";
    private String str3 = "Auditory stimulus optimization with feedback from fuzzy clustering of neuronal responses.";
    private StringTFIDF tfidf;

    protected void setUp() throws Exception {
        this.corpus = new ArrayList();
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str1)));
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str2)));
        this.corpus.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str3)));
        StringTFIDFTestOnlyCorpusInitialization.assertNotNull(this.corpus);
    }

    public void testTFIDF() {
        this.tfidf = new StringTFIDF(this.corpus);
        StringTFIDFTestOnlyCorpusInitialization.assertNotNull((Object)this.tfidf);
        double d = 0.22347915256519232;
        StringTFIDFTestOnlyCorpusInitialization.assertEquals((Object)this.tfidf.getSimilarity(StringUtils.clean(this.str1), StringUtils.clean(this.str2)), (Object)d);
    }

    public void testTFIDFEquality() {
        this.tfidf = new StringTFIDF(this.corpus);
        StringTFIDFTestOnlyCorpusInitialization.assertNotNull((Object)this.tfidf);
        StringTFIDFTestOnlyCorpusInitialization.assertEquals((Object)this.tfidf.getSimilarity(this.str1, this.str1), (Object)0.9999999999999999);
    }
}

