/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.weightingscheme;

import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import java.util.ArrayList;
import junit.framework.TestCase;
import simpack.measure.weightingscheme.StringTFIDF;
import simpack.tokenizer.SplittedStringTokenizerCohen;
import simpack.util.corpus.StringUtils;

public class StringTFIDFTest
extends TestCase {
    private ArrayList<StringWrapper> corpus1;
    private ArrayList<StringWrapper> corpus2;
    private String str1 = "Auditory scene analysis based on time-frequency integration of shared FM and AM (II): Optimum time-domain integration and stream sound reconstruction.";
    private String str2 = "Auditory scene analysis based on time-frequency integration of shared FM and AM (I): Lagrange differential features and frequency-axis integration.";
    private String str3 = "Auditory stimulus optimization with feedback from fuzzy clustering of neuronal responses.";
    private String str4 = "Returns food of grocery store";
    private String str5 = "This service returns store food";
    private String str6 = "A grocery service selling food";
    private StringTFIDF tfidf;

    protected void setUp() throws Exception {
        this.corpus1 = new ArrayList();
        this.corpus1.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str1)));
        this.corpus1.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str2)));
        this.corpus1.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str3)));
        this.corpus2 = new ArrayList();
        this.corpus2.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str4)));
        this.corpus2.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str5)));
        this.corpus2.add((StringWrapper)new BasicStringWrapper(StringUtils.clean(this.str6)));
    }

    public void testTFIDF() {
        String string = StringUtils.clean(this.str4);
        String string2 = StringUtils.clean(this.str6);
        this.tfidf = new StringTFIDF(this.corpus1, string, string2);
        StringTFIDFTest.assertNotNull((Object)this.tfidf);
        double d = 0.5;
        StringTFIDFTest.assertEquals((Object)this.tfidf.getSimilarity(), (Object)d);
    }

    public void testTFIDF2() {
        String string = StringUtils.clean(this.str1);
        String string2 = StringUtils.clean(this.str2);
        this.tfidf = new StringTFIDF(this.corpus1, string, string2, new SplittedStringTokenizerCohen("\\s+"));
        StringTFIDFTest.assertNotNull((Object)this.tfidf);
        double d = 0.9718253158075502;
        StringTFIDFTest.assertEquals((Object)this.tfidf.getSimilarity(), (Object)d);
    }

    public void testTFIDFEquality() {
        this.tfidf = new StringTFIDF(this.corpus1, this.str1, this.str1);
        StringTFIDFTest.assertNotNull((Object)this.tfidf);
        StringTFIDFTest.assertEquals((Object)this.tfidf.getSimilarity(), (Object)0.9999999999999999);
    }
}

