/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.weightingscheme;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import simpack.accessor.list.LuceneIndexAccessor;
import simpack.exception.InvalidElementException;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.vector.Cosine;
import simpack.measure.weightingscheme.LuceneTFIDF;
import simpack.util.Vector;

public class LuceneTFIDFTest
extends TestCase {
    private String file1 = "data/corpus/SWEET_1998734.txt";
    private String file2 = "data/corpus/SWEET_1998395.txt";
    private String file3 = "data/corpus/SWEET_2096309.txt";
    private String index = "data" + File.separator + "index";
    private LuceneIndexAccessor<String> accessor;

    public void setUp() {
        try {
            this.accessor = new LuceneIndexAccessor(this.index);
            LuceneTFIDFTest.assertNotNull(this.accessor);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void testTFIDF() {
        try {
            LuceneTFIDF luceneTFIDF = new LuceneTFIDF(this.accessor, this.file1, this.file2);
            LuceneTFIDFTest.assertNotNull((Object)luceneTFIDF);
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.calculate());
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.isCalculated());
            Vector vector = new Vector((Number[])new Double[]{0.75, 0.5342384456611643, 0.75, 1.0, 0.75, 0.75, 0.75, 1.0, 0.75, 0.75});
            Vector vector2 = new Vector((Number[])new Double[]{1.0, 0.5342384456611643, 0.75, 0.75, 0.75, 0.75, 0.75, 1.0, 0.75, 0.75});
            LuceneTFIDFTest.assertNotNull((Object)vector);
            LuceneTFIDFTest.assertNotNull((Object)vector2);
            Cosine cosine = new Cosine(vector, vector2);
            LuceneTFIDFTest.assertNotNull((Object)cosine);
            LuceneTFIDFTest.assertTrue((boolean)cosine.calculate());
            LuceneTFIDFTest.assertTrue((boolean)cosine.isCalculated());
            LuceneTFIDFTest.assertEquals((Object)luceneTFIDF.getSimilarity(), (Object)cosine.getSimilarity());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
    }

    public void testTFIDF2() {
        try {
            LuceneTFIDF luceneTFIDF = new LuceneTFIDF(this.accessor, this.file1, this.file3);
            LuceneTFIDFTest.assertNotNull((Object)luceneTFIDF);
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.calculate());
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.isCalculated());
            Vector vector = new Vector((Number[])new Double[]{0.5342384456611643});
            Vector vector2 = new Vector((Number[])new Double[]{0.7123179275482191});
            LuceneTFIDFTest.assertNotNull((Object)vector);
            LuceneTFIDFTest.assertNotNull((Object)vector2);
            Cosine cosine = new Cosine(vector, vector2);
            LuceneTFIDFTest.assertNotNull((Object)cosine);
            LuceneTFIDFTest.assertTrue((boolean)cosine.calculate());
            LuceneTFIDFTest.assertTrue((boolean)cosine.isCalculated());
            LuceneTFIDFTest.assertEquals((Object)luceneTFIDF.getSimilarity(), (Object)cosine.getSimilarity());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
    }

    public void testTFIDF3() {
        LuceneTFIDF luceneTFIDF = null;
        try {
            luceneTFIDF = new LuceneTFIDF(this.accessor, this.file2, this.file3);
            LuceneTFIDFTest.assertNotNull((Object)luceneTFIDF);
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.calculate());
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.isCalculated());
            Vector vector = new Vector((Number[])new Double[]{0.5342384456611643});
            Vector vector2 = new Vector((Number[])new Double[]{0.7123179275482191});
            LuceneTFIDFTest.assertNotNull((Object)vector);
            LuceneTFIDFTest.assertNotNull((Object)vector2);
            Cosine cosine = new Cosine(vector, vector2);
            LuceneTFIDFTest.assertNotNull((Object)cosine);
            LuceneTFIDFTest.assertTrue((boolean)cosine.calculate());
            LuceneTFIDFTest.assertTrue((boolean)cosine.isCalculated());
            LuceneTFIDFTest.assertEquals((Object)luceneTFIDF.getSimilarity(), (Object)cosine.getSimilarity());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
    }

    public void testTFIDFSameDocument() {
        try {
            LuceneTFIDF luceneTFIDF = new LuceneTFIDF(this.accessor, this.file1, this.file1);
            LuceneTFIDFTest.assertNotNull((Object)luceneTFIDF);
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.calculate());
            LuceneTFIDFTest.assertTrue((boolean)luceneTFIDF.isCalculated());
            Vector vector = new Vector((Number[])new Double[]{0.75, 1.0540988310811232, 0.5342384456611643, 0.75, 1.0, 1.0540988310811232, 1.0540988310811232, 1.0540988310811232, 0.75, 0.75, 0.75, 1.0, 0.75, 1.0540988310811232, 0.75, 1.0540988310811232});
            Vector vector2 = new Vector((Number[])new Double[]{0.75, 1.0540988310811232, 0.5342384456611643, 0.75, 1.0, 1.0540988310811232, 1.0540988310811232, 1.0540988310811232, 0.75, 0.75, 0.75, 1.0, 0.75, 1.0540988310811232, 0.75, 1.0540988310811232});
            LuceneTFIDFTest.assertNotNull((Object)vector);
            LuceneTFIDFTest.assertNotNull((Object)vector2);
            Cosine cosine = new Cosine(vector, vector2);
            LuceneTFIDFTest.assertNotNull((Object)cosine);
            LuceneTFIDFTest.assertTrue((boolean)cosine.calculate());
            LuceneTFIDFTest.assertTrue((boolean)cosine.isCalculated());
            LuceneTFIDFTest.assertEquals((Object)luceneTFIDF.getSimilarity(), (Object)cosine.getSimilarity());
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
    }

    public void testTFIDFInvalidName() {
        try {
            LuceneTFIDF luceneTFIDF = new LuceneTFIDF(this.accessor, this.file1, "file2.txxt");
            LuceneTFIDFTest.fail((String)"Should throw an InvalidElementException.");
        }
        catch (InvalidElementException invalidElementException) {
            LuceneTFIDFTest.assertTrue((boolean)true);
        }
    }
}

