/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.vector;

import junit.framework.TestCase;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.vector.StdPearson;
import simpack.measure.vector.ZPearson;
import simpack.util.Vector;

public class PearsonTest
extends TestCase {
    private Vector<Double> v1 = new Vector();
    private Vector<Double> v2 = new Vector();
    private Vector<Double> v3 = new Vector();
    private Vector<Double> v4 = new Vector();
    private Vector<Double> v5 = new Vector();

    public void setUp() {
        this.v1.add(1.0);
        this.v1.add(2.0);
        this.v1.add(3.0);
        this.v2.add(2.0);
        this.v2.add(5.0);
        this.v2.add(8.0);
        this.v3.add(1.0);
        this.v3.add(2.0);
        this.v4.add(1.0);
        this.v4.add(1.0);
        this.v4.add(1.0);
        this.v5.add(1.0);
        this.v5.add(0.0);
        this.v5.add(1.0);
    }

    public void testZPearson() {
        ZPearson zPearson = null;
        try {
            zPearson = new ZPearson(this.v1, this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        PearsonTest.assertNotNull(zPearson);
        PearsonTest.assertTrue((boolean)zPearson.calculate());
        PearsonTest.assertTrue((boolean)zPearson.isCalculated());
        double d = 0.0;
        try {
            d = this.v1.getDotProduct(this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        double d2 = this.v1.getNorm(1.0) * this.v2.getNorm(1.0);
        double d3 = Math.pow(this.v1.getNorm(2.0), 2.0);
        double d4 = Math.pow(this.v1.getNorm(1.0), 2.0);
        double d5 = Math.pow(this.v2.getNorm(2.0), 2.0);
        double d6 = Math.pow(this.v2.getNorm(1.0), 2.0);
        double d7 = this.v1.size();
        PearsonTest.assertEquals((Object)zPearson.getSimilarity(), (Object)(new Double(d - d2 / d7) / Math.sqrt((d3 - d4 / d7) * (d5 - d6 / d7))));
    }

    public void testStdPearson() {
        StdPearson stdPearson = null;
        try {
            stdPearson = new StdPearson(this.v1, this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        PearsonTest.assertNotNull(stdPearson);
        PearsonTest.assertTrue((boolean)stdPearson.calculate());
        PearsonTest.assertTrue((boolean)stdPearson.isCalculated());
        double d = 6.0;
        double d2 = Math.sqrt(2.0);
        double d3 = Math.sqrt(18.0);
        PearsonTest.assertEquals((Object)stdPearson.getSimilarity(), (Object)new Double(d / (d2 * d3)));
    }

    public void testStdPearson2() {
        StdPearson stdPearson = null;
        try {
            stdPearson = new StdPearson(this.v4, this.v5);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        PearsonTest.assertNotNull(stdPearson);
        PearsonTest.assertTrue((boolean)stdPearson.calculate());
        PearsonTest.assertTrue((boolean)stdPearson.isCalculated());
        double d = 0.6666666666666666;
        double d2 = 0.0 * (1.0 - d) + 0.0 * (0.0 - d) + 0.0 * (1.0 - d);
        double d3 = Math.sqrt(0.0);
        double d4 = Math.sqrt((1.0 - d) * (1.0 - d) + (0.0 - d) * (0.0 - d) + (1.0 - d) * (1.0 - d));
        PearsonTest.assertEquals((Object)stdPearson.getSimilarity(), (Object)new Double(0.5));
    }

    public void testZPearsonVsStdPerson() {
        ZPearson zPearson = null;
        StdPearson stdPearson = null;
        try {
            zPearson = new ZPearson(this.v1, this.v2);
            stdPearson = new StdPearson(this.v1, this.v2);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        PearsonTest.assertNotNull(zPearson);
        PearsonTest.assertTrue((boolean)zPearson.calculate());
        PearsonTest.assertTrue((boolean)zPearson.isCalculated());
        PearsonTest.assertNotNull(stdPearson);
        PearsonTest.assertTrue((boolean)stdPearson.calculate());
        PearsonTest.assertTrue((boolean)stdPearson.isCalculated());
        System.out.println(zPearson.getSimilarity());
        System.out.println(stdPearson.getSimilarity());
        PearsonTest.assertEquals((Object)zPearson.getSimilarity(), (Object)stdPearson.getSimilarity());
    }

    public void testInvalidVectorSizeException() {
        ZPearson zPearson = null;
        try {
            zPearson = new ZPearson(this.v1, this.v3);
            PearsonTest.fail((String)"Should throw an InvalidVectorSizeException");
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            PearsonTest.assertTrue((boolean)true);
        }
    }
}

