/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.tree;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import simpack.accessor.tree.SimpleTreeAccessor;
import simpack.api.ITreeNode;
import simpack.exception.InvalidElementException;
import simpack.measure.tree.TreeEditDistance;
import simpack.util.conversion.WorstCaseDistanceConversion;
import simpack.util.tree.comparator.NamedTreeNodeComparator;
import simpack.util.xml.XMLIterator;
import simpack.util.xml.XMLVisitor;

public class XMLTreeEditDistanceTest
extends TestCase {
    private ITreeNode tree1;
    private ITreeNode tree2;
    private TreeEditDistance calc;
    String xmlFilePath1 = "xml/doc1.xml";
    String xmlFilePath2 = "xml/doc2.xml";

    protected void setUp() throws Exception {
        this.tree1 = this.generateSampleT1();
        this.tree2 = this.generateSampleT2();
    }

    public void testEditDistance() {
        XMLTreeEditDistanceTest.assertNotNull((Object)this.tree1);
        XMLTreeEditDistanceTest.assertNotNull((Object)this.tree2);
        try {
            this.calc = new TreeEditDistance(new SimpleTreeAccessor(this.tree1), new SimpleTreeAccessor(this.tree2), new NamedTreeNodeComparator(), new WorstCaseDistanceConversion());
            XMLTreeEditDistanceTest.assertNotNull((Object)this.calc);
            XMLTreeEditDistanceTest.assertTrue((boolean)this.calc.calculate());
            XMLTreeEditDistanceTest.assertTrue((boolean)this.calc.isCalculated());
            XMLTreeEditDistanceTest.assertEquals((Object)this.calc.getTreeEditDistance(), (Object)47.0);
            XMLTreeEditDistanceTest.assertEquals((Object)this.calc.getSimilarity(), (Object)0.8629737609329446);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
    }

    private ITreeNode generateSampleT1() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.xmlFilePath1);
            Element element = document.getDocumentElement();
            XMLVisitor xMLVisitor = new XMLVisitor();
            XMLIterator xMLIterator = new XMLIterator(true, true);
            xMLIterator.setVisitor(xMLVisitor);
            xMLIterator.scanNodes(element);
            ITreeNode iTreeNode = xMLVisitor.getTree();
            return iTreeNode;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private ITreeNode generateSampleT2() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.xmlFilePath2);
            Element element = document.getDocumentElement();
            XMLVisitor xMLVisitor = new XMLVisitor();
            XMLIterator xMLIterator = new XMLIterator(true, true);
            xMLIterator.setVisitor(xMLVisitor);
            xMLIterator.scanNodes(element);
            ITreeNode iTreeNode = xMLVisitor.getTree();
            return iTreeNode;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private void printTree(ITreeNode iTreeNode, int n) {
        if (iTreeNode != null) {
            Object object;
            this.indent(n);
            Node node = (Node)iTreeNode.getUserObject();
            if (node.getNodeType() == 3) {
                object = (Text)node;
                String string = object.getData().trim();
                if (string != null && string.length() > 0) {
                    System.out.println(string);
                }
            } else {
                System.out.println(node.toString());
            }
            object = iTreeNode.children();
            while (object.hasMoreElements()) {
                this.printTree((ITreeNode)object.nextElement(), n + 1);
            }
        }
    }

    private void indent(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
    }
}

