/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.string;

import junit.framework.TestCase;
import simpack.accessor.string.StringAccessor;
import simpack.measure.string.Jaro;

public class JaroTest
extends TestCase {
    public void testCalculationSimilarity() {
        Jaro jaro = new Jaro(new StringAccessor("Individual"), new StringAccessor("IndividualPerson"));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(0.875));
    }

    public void testCalculationSimilarity2() {
        Jaro jaro = new Jaro(new StringAccessor("info"), new StringAccessor("hasID"));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(-1.0));
    }

    public void testCalculationSimilarity3() {
        Jaro jaro = new Jaro(new StringAccessor("Individual"), new StringAccessor("Address"));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(-1.0));
    }

    public void testCalculationSimilarity4() {
        Jaro jaro = new Jaro(new StringAccessor("test"), new StringAccessor("test"));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(1.0));
        jaro = new Jaro(new StringAccessor("testt"), new StringAccessor("westt"));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(0.8666666666666667));
        jaro = new Jaro(new StringAccessor("testt"), new StringAccessor("nada"));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(0.0));
    }

    public void testCalculationEmptyStrings() {
        Jaro jaro = new Jaro(new StringAccessor(""), new StringAccessor("test"));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(0.0));
        jaro = new Jaro(new StringAccessor("test"), new StringAccessor(""));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(0.0));
        jaro = new Jaro(new StringAccessor(""), new StringAccessor(""));
        JaroTest.assertNotNull((Object)jaro);
        JaroTest.assertTrue((boolean)jaro.calculate());
        JaroTest.assertTrue((boolean)jaro.isCalculated());
        JaroTest.assertEquals((Object)jaro.getSimilarity(), (Object)new Double(0.0));
    }
}

