/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.sequence;

import junit.framework.TestCase;
import org.junit.Test;
import simpack.accessor.string.StringAccessor;
import simpack.measure.sequence.LOL;
import simpack.tokenizer.SplittedStringTokenizer;
import simpack.util.conversion.WorstCaseDistanceConversion;

public class LOLTest
extends TestCase {
    private StringAccessor sa1 = new StringAccessor("this language levenshtein", new SplittedStringTokenizer("\\s+"));
    private StringAccessor sa2 = new StringAccessor("this languages shteinleven", new SplittedStringTokenizer("\\s+"));
    private StringAccessor sa3 = new StringAccessor("MATES", new SplittedStringTokenizer("\\s+"));
    private StringAccessor sa4 = new StringAccessor("Multiagent System Technologies: Third German Conference, MATES 2005, Koblenz, Germany, September 11-13, 2005. Proceedings", new SplittedStringTokenizer("\\s+"));

    @Test
    public void testSimilarity() {
        LOL<String> lOL = new LOL<String>(this.sa1, this.sa1, 0.3);
        LOLTest.assertEquals((Object)lOL.getSimilarity(), (Object)new Double(1.0));
    }

    @Test
    public void testSimilarity2() {
        LOL<String> lOL = new LOL<String>(this.sa1, this.sa2, 0.3);
        LOLTest.assertEquals((Object)lOL.getSimilarity(), (Object)new Double(0.6666666666666666));
    }

    @Test
    public void testSimilarity3() {
        LOL<String> lOL = new LOL<String>(new StringAccessor(""), this.sa2);
        LOLTest.assertEquals((Object)lOL.getSimilarity(), (Object)new Double(0.0));
    }

    @Test
    public void testSimilarity4() {
        LOL<String> lOL = new LOL<String>(this.sa1, new StringAccessor(""));
        LOLTest.assertEquals((Object)lOL.getSimilarity(), (Object)new Double(0.0));
    }

    @Test
    public void testSimilarity5() {
        LOL<String> lOL = new LOL<String>(new StringAccessor(""), new StringAccessor(""));
        LOLTest.assertEquals((Object)lOL.getSimilarity(), (Object)new Double(0.0));
    }

    @Test
    public void testSimilarity6() {
        try {
            LOL<String> lOL = new LOL<String>(null, new StringAccessor(""));
            LOLTest.fail((String)"Should throw NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            LOLTest.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSimilarity7() {
        LOL<String> lOL = new LOL<String>(this.sa3, this.sa4);
        LOLTest.assertEquals((Object)lOL.getSimilarity(), (Object)0.07142857142857142);
    }

    @Test
    public void testSimilarity8() {
        StringAccessor stringAccessor = new StringAccessor("provid materi", new SplittedStringTokenizer("\\s+"));
        StringAccessor stringAccessor2 = new StringAccessor("custom servic", new SplittedStringTokenizer("\\s+"));
        LOL<String> lOL = new LOL<String>(stringAccessor, stringAccessor2, new WorstCaseDistanceConversion(), 0.7);
        LOLTest.assertEquals((Object)lOL.getSimilarity(), (Object)0.0);
    }
}

