/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.it;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.it.Lin;
import simpack.util.graph.GraphNode;

public class LinOntologyTest
extends TestCase {
    private String SUMO_OntologyURI = "http://127.0.0.1/ontology/simplified_sumo.owl";
    private String SUMO_OntologyBaseURI = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String SUMO_OntologyRootURI = "http://127.0.0.1/ontology/simplified_sumo.owl#SUMORoot";
    private String altOntologyURL = "file:ontology" + File.separator + "simplified_sumo.owl";
    private String ontClassA = "http://127.0.0.1/ontology/simplified_sumo.owl#Shrimp";
    private String ontClassB = "http://127.0.0.1/ontology/simplified_sumo.owl#Wine";
    private String ontClassC = "http://lsdis.cs.uga.edu/proj/semdis/testbed/#Politician";
    private String ontClassD = "http://127.0.0.1/ontology/simplified_sumo.owl#Shellfish";
    private String ontClassE = "http://127.0.0.1/ontology/simplified_sumo.owl#Entity";
    private String ontClassF = "http://127.0.0.1/ontology/simplified_sumo.owl#DualObjectProcess";
    private String ontClassG = "http://127.0.0.1/ontology/simplified_sumo.owl#Meat";
    private OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public void testJenaOntologyAccessor() {
        Lin lin = null;
        try {
            lin = new Lin(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassB));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        LinOntologyTest.assertNotNull(lin);
        LinOntologyTest.assertTrue((boolean)lin.calculate());
        LinOntologyTest.assertTrue((boolean)lin.isCalculated());
        Double d = new Double(2.0 * Math.log(0.15702479338842976) / (Math.log(0.008264462809917356) + Math.log(0.008264462809917356)));
        LinOntologyTest.assertEquals((Object)lin.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityInvalidClassName() {
        Lin lin = null;
        try {
            lin = new Lin(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassC));
            LinOntologyTest.fail((String)"Should raise an InvalidNodException");
        }
        catch (InvalidElementException invalidElementException) {
            LinOntologyTest.assertTrue((boolean)true);
        }
    }

    public void testCalculateSimilaritySameClass() {
        Lin lin = null;
        try {
            lin = new Lin(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassA));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        LinOntologyTest.assertNotNull(lin);
        LinOntologyTest.assertTrue((boolean)lin.calculate());
        LinOntologyTest.assertTrue((boolean)lin.isCalculated());
        Double d = new Double(2.0 * Math.log(0.024793388429752067) / (Math.log(0.008264462809917356) + Math.log(0.008264462809917356)));
        LinOntologyTest.assertEquals((Object)lin.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsParentOfOther() {
        Lin lin = null;
        try {
            lin = new Lin(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassD));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        LinOntologyTest.assertNotNull(lin);
        LinOntologyTest.assertTrue((boolean)lin.calculate());
        LinOntologyTest.assertTrue((boolean)lin.isCalculated());
        Double d = new Double(2.0 * Math.log(0.024793388429752067) / (Math.log(0.008264462809917356) + Math.log(0.024793388429752067)));
        LinOntologyTest.assertEquals((Object)lin.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsAncestorOfOther() {
        Lin lin = null;
        try {
            lin = new Lin(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassA), new GraphNode(this.ontClassG));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        LinOntologyTest.assertNotNull(lin);
        LinOntologyTest.assertTrue((boolean)lin.calculate());
        LinOntologyTest.assertTrue((boolean)lin.isCalculated());
        Double d = new Double(2.0 * Math.log(0.11570247933884298) / (Math.log(0.008264462809917356) + Math.log(0.11570247933884298)));
        LinOntologyTest.assertEquals((Object)lin.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityMRCAIsRootOfOntology() {
        Lin lin = null;
        try {
            lin = new Lin(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassE), new GraphNode(this.ontClassF));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        LinOntologyTest.assertNotNull(lin);
        LinOntologyTest.assertTrue((boolean)lin.calculate());
        LinOntologyTest.assertTrue((boolean)lin.isCalculated());
        Double d = new Double(0.0);
        LinOntologyTest.assertEquals((Object)lin.getSimilarity(), (Object)d);
    }

    public void testCalculateSimilarityOneIsRootOfOntology() {
        Lin lin = null;
        try {
            lin = new Lin(new JenaOntologyAccessor(this.SUMO_OntologyURI, this.altOntologyURL, this.SUMO_OntologyBaseURI, this.SUMO_OntologyRootURI, this.ontModelSpec), new GraphNode(this.ontClassE), new GraphNode(this.SUMO_OntologyRootURI));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        LinOntologyTest.assertNotNull(lin);
        LinOntologyTest.assertTrue((boolean)lin.calculate());
        LinOntologyTest.assertTrue((boolean)lin.isCalculated());
        Double d = new Double(0.0);
        LinOntologyTest.assertEquals((Object)lin.getSimilarity(), (Object)d);
    }
}

