/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import simpack.accessor.graph.SimpleGraphAccessor;
import simpack.api.IGraphAccessor;
import simpack.measure.graph.MaxGraphIsoCovering;
import simpack.measure.graph.SubgraphIsomorphism;
import simpack.util.graph.Clique;
import simpack.util.graph.GraphNode;

public class MaxGraphIsoCoveringTest
extends TestCase {
    public static Logger logger = Logger.getLogger(MaxGraphIsoCoveringTest.class);
    private IGraphAccessor graph1;
    private IGraphAccessor graph2;
    private IGraphAccessor graph3;
    private IGraphAccessor graph4;
    private IGraphAccessor emptyGraph;
    private MaxGraphIsoCovering calc1;

    protected void setUp() throws Exception {
        this.graph1 = this.generateSampleG1();
        this.graph2 = this.generateSampleG2();
        this.graph3 = this.generateSampleG3();
        this.graph4 = this.generateSampleG4();
        this.emptyGraph = new SimpleGraphAccessor();
        MaxGraphIsoCoveringTest.assertNotNull((Object)this.graph1);
        MaxGraphIsoCoveringTest.assertNotNull((Object)this.graph2);
        MaxGraphIsoCoveringTest.assertNotNull((Object)this.graph3);
        MaxGraphIsoCoveringTest.assertNotNull((Object)this.graph4);
        MaxGraphIsoCoveringTest.assertNotNull((Object)this.emptyGraph);
    }

    public void testEmptyGraph() {
        this.calc1 = new MaxGraphIsoCovering(this.graph1, this.emptyGraph, SubgraphIsomorphism.DEFAULT_NODE_LABEL_SIMILARITY_MEASURE, 1, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, false, "larger");
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.calculate());
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.isCalculated());
        MaxGraphIsoCoveringTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)0.0);
    }

    public void testEmptyGraph2() {
        this.calc1 = new MaxGraphIsoCovering(this.emptyGraph, this.graph2, SubgraphIsomorphism.DEFAULT_NODE_LABEL_SIMILARITY_MEASURE, 1, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, false, "larger");
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.calculate());
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.isCalculated());
        MaxGraphIsoCoveringTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)0.0);
    }

    public void testEmptyGraph3() {
        this.calc1 = new MaxGraphIsoCovering(this.emptyGraph, this.emptyGraph, SubgraphIsomorphism.DEFAULT_NODE_LABEL_SIMILARITY_MEASURE, 1, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, false, "larger");
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.calculate());
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.isCalculated());
        MaxGraphIsoCoveringTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)0.0);
    }

    public void testSampleGraph() {
        this.calc1 = new MaxGraphIsoCovering(this.graph1, this.graph2, SubgraphIsomorphism.DEFAULT_NODE_LABEL_SIMILARITY_MEASURE, 1, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, false, "larger");
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.calculate());
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.isCalculated());
        MaxGraphIsoCoveringTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)(-3.0 / (double)this.graph1.size() + 1.0));
    }

    public void testSampleGraphWithGroups() {
        this.calc1 = new MaxGraphIsoCovering(this.graph3, this.graph4, SubgraphIsomorphism.DEFAULT_NODE_LABEL_SIMILARITY_MEASURE, 1, SubgraphIsomorphism.DEFAULT_STRUCTURE_WEIGHT, SubgraphIsomorphism.DEFAULT_LABEL_WEIGHT, SubgraphIsomorphism.DEFAULT_DENOMINATOR, true, "smaller");
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.calculate());
        MaxGraphIsoCoveringTest.assertTrue((boolean)this.calc1.isCalculated());
        if (logger.isDebugEnabled()) {
            ArrayList<Clique> arrayList = this.calc1.getCovering();
            for (Clique clique : arrayList) {
                System.out.println(clique.getClique().toString() + " " + clique.getSimilarity());
            }
        }
        MaxGraphIsoCoveringTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)(-2.0 / (double)this.graph3.size() + 1.0));
    }

    private IGraphAccessor generateSampleG1() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("1");
        GraphNode graphNode2 = new GraphNode("2");
        GraphNode graphNode3 = new GraphNode("3");
        GraphNode graphNode4 = new GraphNode("4");
        GraphNode graphNode5 = new GraphNode("5");
        GraphNode graphNode6 = new GraphNode("6");
        GraphNode graphNode7 = new GraphNode("7");
        GraphNode graphNode8 = new GraphNode("8");
        GraphNode graphNode9 = new GraphNode("9");
        GraphNode graphNode10 = new GraphNode("10");
        GraphNode graphNode11 = new GraphNode("11");
        GraphNode graphNode12 = new GraphNode("12");
        GraphNode graphNode13 = new GraphNode("13");
        GraphNode graphNode14 = new GraphNode("14");
        GraphNode graphNode15 = new GraphNode("15");
        GraphNode graphNode16 = new GraphNode("16");
        GraphNode graphNode17 = new GraphNode("17");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode2, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode7);
        simpleGraphAccessor.setEdge(graphNode4, graphNode8);
        simpleGraphAccessor.setEdge(graphNode6, graphNode9);
        simpleGraphAccessor.setEdge(graphNode7, graphNode10);
        simpleGraphAccessor.setEdge(graphNode7, graphNode11);
        simpleGraphAccessor.setEdge(graphNode7, graphNode12);
        simpleGraphAccessor.setEdge(graphNode8, graphNode13);
        simpleGraphAccessor.setEdge(graphNode9, graphNode13);
        simpleGraphAccessor.setEdge(graphNode9, graphNode14);
        simpleGraphAccessor.setEdge(graphNode9, graphNode15);
        simpleGraphAccessor.setEdge(graphNode10, graphNode15);
        simpleGraphAccessor.setEdge(graphNode10, graphNode16);
        simpleGraphAccessor.setEdge(graphNode11, graphNode16);
        simpleGraphAccessor.setEdge(graphNode12, graphNode17);
        simpleGraphAccessor.setEdge(graphNode17, graphNode16);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG2() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("1");
        GraphNode graphNode2 = new GraphNode("5");
        GraphNode graphNode3 = new GraphNode("3");
        GraphNode graphNode4 = new GraphNode("10");
        GraphNode graphNode5 = new GraphNode("11");
        GraphNode graphNode6 = new GraphNode("12");
        GraphNode graphNode7 = new GraphNode("2");
        GraphNode graphNode8 = new GraphNode("17");
        GraphNode graphNode9 = new GraphNode("8");
        GraphNode graphNode10 = new GraphNode("4");
        GraphNode graphNode11 = new GraphNode("9");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode2, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode7);
        simpleGraphAccessor.setEdge(graphNode4, graphNode10);
        simpleGraphAccessor.setEdge(graphNode5, graphNode10);
        simpleGraphAccessor.setEdge(graphNode6, graphNode8);
        simpleGraphAccessor.setEdge(graphNode7, graphNode9);
        simpleGraphAccessor.setEdge(graphNode8, graphNode10);
        simpleGraphAccessor.setEdge(graphNode8, graphNode11);
        simpleGraphAccessor.setEdge(graphNode9, graphNode11);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG3() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("A");
        GraphNode graphNode2 = new GraphNode("B");
        GraphNode graphNode3 = new GraphNode("C");
        GraphNode graphNode4 = new GraphNode("D");
        GraphNode graphNode5 = new GraphNode("E");
        GraphNode graphNode6 = new GraphNode("F");
        GraphNode graphNode7 = new GraphNode("G");
        GraphNode graphNode8 = new GraphNode("H");
        GraphNode graphNode9 = new GraphNode("I");
        GraphNode graphNode10 = new GraphNode("J");
        GraphNode graphNode11 = new GraphNode("K");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode2, graphNode4);
        simpleGraphAccessor.setEdge(graphNode2, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode6);
        simpleGraphAccessor.setEdge(graphNode3, graphNode7);
        simpleGraphAccessor.setEdge(graphNode6, graphNode8);
        simpleGraphAccessor.setEdge(graphNode6, graphNode9);
        simpleGraphAccessor.setEdge(graphNode6, graphNode10);
        simpleGraphAccessor.setEdge(graphNode6, graphNode11);
        simpleGraphAccessor.setEdge(graphNode7, graphNode8);
        simpleGraphAccessor.setEdge(graphNode7, graphNode9);
        simpleGraphAccessor.setEdge(graphNode7, graphNode10);
        simpleGraphAccessor.setEdge(graphNode7, graphNode11);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG4() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        GraphNode graphNode = new GraphNode("a");
        GraphNode graphNode2 = new GraphNode("b");
        GraphNode graphNode3 = new GraphNode("c");
        GraphNode graphNode4 = new GraphNode("d");
        GraphNode graphNode5 = new GraphNode("e");
        GraphNode graphNode6 = new GraphNode("f");
        GraphNode graphNode7 = new GraphNode("g");
        GraphNode graphNode8 = new GraphNode("h");
        GraphNode graphNode9 = new GraphNode("i");
        GraphNode graphNode10 = new GraphNode("j");
        GraphNode graphNode11 = new GraphNode("k");
        GraphNode graphNode12 = new GraphNode("l");
        simpleGraphAccessor.setEdge(graphNode, graphNode2);
        simpleGraphAccessor.setEdge(graphNode, graphNode3);
        simpleGraphAccessor.setEdge(graphNode, graphNode4);
        simpleGraphAccessor.setEdge(graphNode, graphNode5);
        simpleGraphAccessor.setEdge(graphNode2, graphNode6);
        simpleGraphAccessor.setEdge(graphNode2, graphNode7);
        simpleGraphAccessor.setEdge(graphNode2, graphNode8);
        simpleGraphAccessor.setEdge(graphNode3, graphNode9);
        simpleGraphAccessor.setEdge(graphNode4, graphNode12);
        simpleGraphAccessor.setEdge(graphNode5, graphNode10);
        simpleGraphAccessor.setEdge(graphNode5, graphNode11);
        simpleGraphAccessor.setEdge(graphNode9, graphNode12);
        return simpleGraphAccessor;
    }
}

