/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import junit.framework.TestCase;
import simpack.accessor.graph.SimpleGraphAccessor;
import simpack.api.IGraphAccessor;
import simpack.measure.graph.GraphIsomorphism;
import simpack.util.graph.GraphNode;

public class ConstructedGraphIsomorphismTest
extends TestCase {
    private IGraphAccessor graph1;
    private IGraphAccessor graph2a;
    private IGraphAccessor graph2b;
    private IGraphAccessor graph2c;
    private IGraphAccessor graph3;
    private GraphNode n1;
    private GraphNode n2;
    private GraphNode n3;
    private GraphNode n4;
    private GraphNode n5;
    private GraphNode n6;
    private GraphNode n7;
    private GraphNode n8;
    private GraphNode n9;
    private GraphNode n10;
    private GraphNode n11;
    private GraphNode n12;
    private GraphNode n13;
    private GraphNode n14;
    private GraphNode n15;
    private GraphNode n16;
    private GraphNode n17;
    private GraphIsomorphism calc1;
    private GraphIsomorphism calc2;
    private GraphIsomorphism calc3;
    private GraphIsomorphism calc4;

    public void setUp() {
        this.graph1 = this.generateSampleG1();
        this.graph2a = this.generateSampleG3("normal");
        this.graph2b = this.generateSampleG3("rename");
        this.graph2c = this.generateSampleG3("remove_node");
        this.graph3 = this.generateSampleG2("normal");
        this.calc1 = new GraphIsomorphism(this.graph1, this.graph2a);
        this.calc2 = new GraphIsomorphism(this.graph1, this.graph2b);
        this.calc3 = new GraphIsomorphism(this.graph1, this.graph2c);
        this.calc4 = new GraphIsomorphism(this.graph1, this.graph3);
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc1.calculate());
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc1.isCalculated());
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc2.calculate());
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc2.isCalculated());
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc3.calculate());
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc3.isCalculated());
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc4.calculate());
        ConstructedGraphIsomorphismTest.assertTrue((boolean)this.calc4.isCalculated());
    }

    public void testSameGraph() {
        ConstructedGraphIsomorphismTest.assertNotNull((Object)this.graph1);
        GraphIsomorphism graphIsomorphism = new GraphIsomorphism(this.graph1, this.graph1);
        ConstructedGraphIsomorphismTest.assertEquals((Object)graphIsomorphism.getSimilarity(), (Object)1.0);
    }

    public void testSampleGraph() {
        ConstructedGraphIsomorphismTest.assertNotNull((Object)this.graph1);
        ConstructedGraphIsomorphismTest.assertNotNull((Object)this.graph2a);
        ConstructedGraphIsomorphismTest.assertNotNull((Object)this.graph2b);
        ConstructedGraphIsomorphismTest.assertNotNull((Object)this.graph2c);
        ConstructedGraphIsomorphismTest.assertNotNull((Object)this.graph3);
        ConstructedGraphIsomorphismTest.assertEquals((Object)this.calc1.getSimilarity(), (Object)1.0);
        ConstructedGraphIsomorphismTest.assertEquals((Object)this.calc2.getSimilarity(), (Object)0.9705882352941176);
        ConstructedGraphIsomorphismTest.assertEquals((Object)this.calc3.getSimilarity(), (Object)0.0);
        ConstructedGraphIsomorphismTest.assertEquals((Object)this.calc4.getSimilarity(), (Object)0.0);
    }

    private IGraphAccessor generateSampleG1() {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        this.n1 = new GraphNode("1");
        this.n2 = new GraphNode("2");
        this.n3 = new GraphNode("3");
        this.n4 = new GraphNode("4");
        this.n5 = new GraphNode("5");
        this.n6 = new GraphNode("6");
        this.n7 = new GraphNode("7");
        this.n8 = new GraphNode("8");
        this.n9 = new GraphNode("9");
        this.n10 = new GraphNode("10");
        this.n11 = new GraphNode("11");
        this.n12 = new GraphNode("12");
        this.n13 = new GraphNode("13");
        this.n14 = new GraphNode("14");
        this.n15 = new GraphNode("15");
        this.n16 = new GraphNode("16");
        this.n17 = new GraphNode("17");
        this.n2.addPredecessor(this.n1);
        this.n3.addPredecessor(this.n1);
        this.n4.addPredecessor(this.n2);
        this.n5.addPredecessor(this.n2);
        this.n6.addPredecessor(this.n2);
        this.n6.addPredecessor(this.n3);
        this.n7.addPredecessor(this.n3);
        this.n8.addPredecessor(this.n4);
        this.n9.addPredecessor(this.n6);
        this.n10.addPredecessor(this.n7);
        this.n11.addPredecessor(this.n7);
        this.n12.addPredecessor(this.n7);
        this.n13.addPredecessor(this.n8);
        this.n13.addPredecessor(this.n9);
        this.n14.addPredecessor(this.n9);
        this.n15.addPredecessor(this.n9);
        this.n15.addPredecessor(this.n10);
        this.n16.addPredecessor(this.n10);
        this.n16.addPredecessor(this.n11);
        this.n17.addPredecessor(this.n12);
        this.n16.addPredecessor(this.n17);
        this.n1.addSuccessor(this.n2);
        this.n1.addSuccessor(this.n3);
        this.n2.addSuccessor(this.n4);
        this.n2.addSuccessor(this.n5);
        this.n2.addSuccessor(this.n6);
        this.n3.addSuccessor(this.n6);
        this.n3.addSuccessor(this.n7);
        this.n4.addSuccessor(this.n8);
        this.n6.addSuccessor(this.n9);
        this.n7.addSuccessor(this.n10);
        this.n7.addSuccessor(this.n11);
        this.n7.addSuccessor(this.n12);
        this.n8.addSuccessor(this.n13);
        this.n9.addSuccessor(this.n13);
        this.n9.addSuccessor(this.n14);
        this.n9.addSuccessor(this.n15);
        this.n10.addSuccessor(this.n15);
        this.n10.addSuccessor(this.n16);
        this.n11.addSuccessor(this.n16);
        this.n12.addSuccessor(this.n17);
        this.n17.addSuccessor(this.n16);
        simpleGraphAccessor.addNode(this.n1);
        simpleGraphAccessor.addNode(this.n2);
        simpleGraphAccessor.addNode(this.n3);
        simpleGraphAccessor.addNode(this.n4);
        simpleGraphAccessor.addNode(this.n5);
        simpleGraphAccessor.addNode(this.n6);
        simpleGraphAccessor.addNode(this.n7);
        simpleGraphAccessor.addNode(this.n8);
        simpleGraphAccessor.addNode(this.n9);
        simpleGraphAccessor.addNode(this.n10);
        simpleGraphAccessor.addNode(this.n11);
        simpleGraphAccessor.addNode(this.n12);
        simpleGraphAccessor.addNode(this.n13);
        simpleGraphAccessor.addNode(this.n14);
        simpleGraphAccessor.addNode(this.n15);
        simpleGraphAccessor.addNode(this.n16);
        simpleGraphAccessor.addNode(this.n17);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG2(String string) {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        this.n1 = new GraphNode("1");
        this.n2 = new GraphNode("5");
        this.n3 = new GraphNode("3");
        this.n4 = new GraphNode("10");
        this.n5 = new GraphNode("11");
        this.n6 = new GraphNode("12");
        this.n8 = new GraphNode("17");
        this.n9 = new GraphNode("8");
        this.n10 = string.equals("rename") || string.equals("remove_node") || string.equals("remove_edge") ? new GraphNode("16") : new GraphNode("4");
        this.n11 = new GraphNode("9");
        if (!string.equals("remove_node") && !string.equals("remove_edge")) {
            this.n7 = new GraphNode("2");
            simpleGraphAccessor.addNode(this.n7);
            this.n7.addPredecessor(this.n3);
            this.n9.addPredecessor(this.n7);
            this.n3.addSuccessor(this.n7);
            this.n7.addSuccessor(this.n9);
        }
        if (!string.equals("remove_edge")) {
            this.n8.addPredecessor(this.n6);
            this.n6.addSuccessor(this.n8);
        }
        simpleGraphAccessor.addNode(this.n1);
        simpleGraphAccessor.addNode(this.n2);
        simpleGraphAccessor.addNode(this.n3);
        simpleGraphAccessor.addNode(this.n4);
        simpleGraphAccessor.addNode(this.n5);
        simpleGraphAccessor.addNode(this.n6);
        simpleGraphAccessor.addNode(this.n8);
        simpleGraphAccessor.addNode(this.n9);
        simpleGraphAccessor.addNode(this.n10);
        simpleGraphAccessor.addNode(this.n11);
        this.n2.addPredecessor(this.n1);
        this.n3.addPredecessor(this.n1);
        this.n4.addPredecessor(this.n2);
        this.n5.addPredecessor(this.n2);
        this.n6.addPredecessor(this.n2);
        this.n6.addPredecessor(this.n3);
        this.n10.addPredecessor(this.n4);
        this.n10.addPredecessor(this.n5);
        this.n10.addPredecessor(this.n8);
        this.n11.addPredecessor(this.n8);
        this.n11.addPredecessor(this.n9);
        this.n1.addSuccessor(this.n2);
        this.n1.addSuccessor(this.n3);
        this.n2.addSuccessor(this.n4);
        this.n2.addSuccessor(this.n5);
        this.n2.addSuccessor(this.n6);
        this.n3.addSuccessor(this.n6);
        this.n4.addSuccessor(this.n10);
        this.n5.addSuccessor(this.n10);
        this.n8.addSuccessor(this.n10);
        this.n8.addSuccessor(this.n11);
        this.n9.addSuccessor(this.n11);
        return simpleGraphAccessor;
    }

    private IGraphAccessor generateSampleG3(String string) {
        SimpleGraphAccessor simpleGraphAccessor = new SimpleGraphAccessor();
        this.n1 = new GraphNode("1");
        this.n2 = new GraphNode("2");
        this.n3 = new GraphNode("3");
        this.n4 = new GraphNode("4");
        this.n5 = new GraphNode("5");
        this.n7 = new GraphNode("7");
        this.n8 = new GraphNode("8");
        this.n9 = new GraphNode("9");
        this.n10 = new GraphNode("10");
        this.n11 = new GraphNode("11");
        this.n13 = new GraphNode("13");
        this.n14 = new GraphNode("14");
        this.n15 = new GraphNode("15");
        this.n16 = new GraphNode("16");
        this.n17 = new GraphNode("17");
        this.n12 = string.equals("rename") || string.equals("remove_node") || string.equals("remove_edge") ? new GraphNode("18") : new GraphNode("12");
        if (!string.equals("remove_node") && !string.equals("remove_edge")) {
            this.n6 = new GraphNode("6");
            simpleGraphAccessor.addNode(this.n6);
            this.n6.addPredecessor(this.n2);
            this.n6.addPredecessor(this.n3);
            this.n9.addPredecessor(this.n6);
            this.n2.addSuccessor(this.n6);
            this.n3.addSuccessor(this.n6);
            this.n6.addSuccessor(this.n9);
        }
        if (!string.equals("remove_edge")) {
            this.n7.addPredecessor(this.n3);
            this.n3.addSuccessor(this.n7);
        }
        this.n2.addPredecessor(this.n1);
        this.n3.addPredecessor(this.n1);
        this.n4.addPredecessor(this.n2);
        this.n5.addPredecessor(this.n2);
        this.n8.addPredecessor(this.n4);
        this.n10.addPredecessor(this.n7);
        this.n11.addPredecessor(this.n7);
        this.n12.addPredecessor(this.n7);
        this.n13.addPredecessor(this.n8);
        this.n13.addPredecessor(this.n9);
        this.n14.addPredecessor(this.n9);
        this.n15.addPredecessor(this.n9);
        this.n15.addPredecessor(this.n10);
        this.n16.addPredecessor(this.n10);
        this.n16.addPredecessor(this.n11);
        this.n17.addPredecessor(this.n12);
        this.n16.addPredecessor(this.n17);
        this.n1.addSuccessor(this.n2);
        this.n1.addSuccessor(this.n3);
        this.n2.addSuccessor(this.n4);
        this.n2.addSuccessor(this.n5);
        this.n4.addSuccessor(this.n8);
        this.n7.addSuccessor(this.n10);
        this.n7.addSuccessor(this.n11);
        this.n7.addSuccessor(this.n12);
        this.n8.addSuccessor(this.n13);
        this.n9.addSuccessor(this.n13);
        this.n9.addSuccessor(this.n14);
        this.n9.addSuccessor(this.n15);
        this.n10.addSuccessor(this.n15);
        this.n10.addSuccessor(this.n16);
        this.n11.addSuccessor(this.n16);
        this.n12.addSuccessor(this.n17);
        this.n17.addSuccessor(this.n16);
        simpleGraphAccessor.addNode(this.n1);
        simpleGraphAccessor.addNode(this.n2);
        simpleGraphAccessor.addNode(this.n3);
        simpleGraphAccessor.addNode(this.n4);
        simpleGraphAccessor.addNode(this.n5);
        simpleGraphAccessor.addNode(this.n7);
        simpleGraphAccessor.addNode(this.n8);
        simpleGraphAccessor.addNode(this.n9);
        simpleGraphAccessor.addNode(this.n10);
        simpleGraphAccessor.addNode(this.n11);
        simpleGraphAccessor.addNode(this.n12);
        simpleGraphAccessor.addNode(this.n13);
        simpleGraphAccessor.addNode(this.n14);
        simpleGraphAccessor.addNode(this.n15);
        simpleGraphAccessor.addNode(this.n16);
        simpleGraphAccessor.addNode(this.n17);
        return simpleGraphAccessor;
    }
}

