/*
 * Decompiled with CFR 0.152.
 */
package simpack.tests.measure.graph;

import com.hp.hpl.jena.ontology.OntModelSpec;
import java.io.File;
import junit.framework.TestCase;
import simpack.accessor.graph.JenaOntologyAccessor;
import simpack.exception.InvalidElementException;
import simpack.measure.graph.ConceptualSimilarity;
import simpack.util.graph.GraphNode;

public class ConceptualSimilarityTest
extends TestCase {
    private String ontologyURI = "http://127.0.0.1/ontology/simplified_sumo.owl";
    private String ontologyBaseURI = "http://127.0.0.1/ontology/simplified_sumo.owl#";
    private String ontologyRootURI = "http://127.0.0.1/ontology/simplified_sumo.owl#SUMORoot";
    private String altOntologyURL = "file:ontology" + File.separator + "simplified_sumo.owl";
    private OntModelSpec ontModelSpec = OntModelSpec.OWL_MEM_RDFS_INF;

    public void testConSim() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        ConceptualSimilarity conceptualSimilarity = null;
        try {
            conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ConceptualSimilarityTest.assertNotNull(conceptualSimilarity);
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.calculate());
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.isCalculated());
        ConceptualSimilarityTest.assertEquals((Object)conceptualSimilarity.getSimilarity(), (Object)new Double(0.6));
    }

    public void testConSimInvalidNodeException() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#HoofedMammalalalal";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#BodyPart";
        try {
            ConceptualSimilarity conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
            ConceptualSimilarityTest.fail((String)"Should raise an InvalidNodeException");
        }
        catch (InvalidElementException invalidElementException) {
            ConceptualSimilarityTest.assertTrue((boolean)true);
        }
    }

    public void testConSimMultiplePathPossible() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Industry";
        ConceptualSimilarity conceptualSimilarity = null;
        try {
            conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ConceptualSimilarityTest.assertNotNull(conceptualSimilarity);
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.calculate());
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.isCalculated());
        ConceptualSimilarityTest.assertEquals((Object)conceptualSimilarity.getSimilarity(), (Object)new Double(0.5));
    }

    public void testConSimSameNode() {
        String string;
        String string2 = string = "http://127.0.0.1/ontology/simplified_sumo.owl#IndependentState";
        ConceptualSimilarity conceptualSimilarity = null;
        try {
            conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ConceptualSimilarityTest.assertNotNull(conceptualSimilarity);
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.calculate());
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.isCalculated());
        ConceptualSimilarityTest.assertEquals((Object)conceptualSimilarity.getSimilarity(), (Object)new Double(1.0));
    }

    public void testConSimOneIsAncestorOfOther() {
        String string = "http://127.0.0.1/ontology/simplified_sumo.owl#Vertebrate";
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Organism";
        ConceptualSimilarity conceptualSimilarity = null;
        try {
            conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ConceptualSimilarityTest.assertNotNull(conceptualSimilarity);
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.calculate());
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.isCalculated());
        ConceptualSimilarityTest.assertEquals((Object)conceptualSimilarity.getSimilarity(), (Object)new Double(0.8333333333333334));
    }

    public void testConSimOneIsRootOfOntology() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Object";
        ConceptualSimilarity conceptualSimilarity = null;
        try {
            conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ConceptualSimilarityTest.assertNotNull(conceptualSimilarity);
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.calculate());
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.isCalculated());
        ConceptualSimilarityTest.assertEquals((Object)conceptualSimilarity.getSimilarity(), (Object)new Double(0.25));
    }

    public void testConSimOneIsRootOfTreeMutliplePathsPossible() {
        String string = this.ontologyRootURI;
        String string2 = "http://127.0.0.1/ontology/simplified_sumo.owl#Transaction";
        ConceptualSimilarity conceptualSimilarity = null;
        try {
            conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ConceptualSimilarityTest.assertNotNull(conceptualSimilarity);
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.calculate());
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.isCalculated());
        ConceptualSimilarityTest.assertEquals((Object)conceptualSimilarity.getSimilarity(), (Object)new Double(0.3333333333333333));
    }

    public void testConSimOneBothRootOfTree() {
        String string = this.ontologyRootURI;
        String string2 = this.ontologyRootURI;
        ConceptualSimilarity conceptualSimilarity = null;
        try {
            conceptualSimilarity = new ConceptualSimilarity(new JenaOntologyAccessor(this.ontologyURI, this.altOntologyURL, this.ontologyBaseURI, this.ontologyRootURI, this.ontModelSpec), new GraphNode(new String(string)), new GraphNode(new String(string2)));
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
        }
        ConceptualSimilarityTest.assertNotNull(conceptualSimilarity);
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.calculate());
        ConceptualSimilarityTest.assertTrue((boolean)conceptualSimilarity.isCalculated());
        ConceptualSimilarityTest.assertEquals((Object)conceptualSimilarity.getSimilarity(), (Object)new Double(1.0));
    }
}

