/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.weightingscheme;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.util.PriorityQueue;
import simpack.accessor.list.LuceneIndexAccessor;
import simpack.exception.InvalidElementException;
import simpack.exception.InvalidVectorSizeException;
import simpack.measure.vector.Cosine;
import simpack.measure.weightingscheme.AbstractTFIDF;
import simpack.util.Vector;
import simpack.util.corpus.Indexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneTFIDF
extends AbstractTFIDF {
    public static Logger logger = Logger.getLogger(LuceneTFIDF.class);
    private String d1;
    private String d2;
    private int id1;
    private int id2;
    private LuceneIndexAccessor indexAccessor;

    public LuceneTFIDF(LuceneIndexAccessor<String> luceneIndexAccessor, String string, String string2) throws InvalidElementException {
        this.indexAccessor = luceneIndexAccessor;
        this.d1 = string;
        this.d2 = string2;
        QueryParser queryParser = new QueryParser("url", Indexer.DEFAULT_ANALYZER);
        try {
            Hits hits = luceneIndexAccessor.getIndexSearcher().search(queryParser.parse(string));
            if (hits.length() > 1) {
                throw new RuntimeException("Document name " + string + " not unique");
            }
            if (hits.length() == 0) {
                throw new InvalidElementException("Document name " + string + " not found in index");
            }
            Document document = hits.doc(0);
            this.id1 = hits.id(0);
            hits = luceneIndexAccessor.getIndexSearcher().search(queryParser.parse(string2));
            if (hits.length() > 1) {
                throw new RuntimeException("Document name " + string2 + " not unique");
            }
            if (hits.length() == 0) {
                throw new InvalidElementException("Document name " + string2 + " not found in index");
            }
            Document document2 = hits.doc(0);
            this.id2 = hits.id(0);
            if (logger.isInfoEnabled()) {
                LuceneTFIDF.getDocumentInfo(document);
                LuceneTFIDF.getDocumentInfo(document2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        this.similarity = new Double(this.getTFIDF(this.d1, this.d2));
        this.setCalculated(true);
        return true;
    }

    private double getTFIDF(String string, String string2) {
        double d = 0.0;
        try {
            PriorityQueue priorityQueue = this.indexAccessor.retrieveTerms(this.id1);
            PriorityQueue priorityQueue2 = this.indexAccessor.retrieveTerms(this.id2);
            d = this.score(priorityQueue, priorityQueue2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return d;
    }

    private double score(PriorityQueue priorityQueue, PriorityQueue priorityQueue2) {
        ArrayList<Double> arrayList;
        double d;
        Object object;
        Object object2;
        Object object3;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        HashMap hashMap = new HashMap();
        while ((object3 = priorityQueue.pop()) != null) {
            object2 = (Object[])object3;
            object = (String)object2[0];
            d = (Double)object2[2];
            if (hashMap.containsKey(object)) {
                ((ArrayList)hashMap.get(object)).add(d);
                continue;
            }
            arrayList = new ArrayList<Double>();
            arrayList.add(d);
            hashMap.put(object, arrayList);
        }
        while ((object3 = priorityQueue2.pop()) != null) {
            object2 = (Object[])object3;
            object = (String)object2[0];
            d = (Double)object2[2];
            if (hashMap.containsKey(object)) {
                ((ArrayList)hashMap.get(object)).add(d);
                continue;
            }
            arrayList = new ArrayList();
            arrayList.add(d);
            hashMap.put(object, arrayList);
        }
        object2 = hashMap.entrySet();
        object = object2.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if (((ArrayList)entry.getValue()).size() != 2) continue;
            logger.debug((Object)entry);
            vector.add(((ArrayList)entry.getValue()).get(0));
            vector2.add(((ArrayList)entry.getValue()).get(1));
        }
        try {
            return new Cosine(vector, vector2).getSimilarity();
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
            return 0.0;
        }
    }

    private static void getDocumentInfo(Document document) {
        PrintStream printStream = System.out;
        printStream.println("url : " + document.get("url"));
        printStream.println("title : " + document.get("title"));
        printStream.println("contents : " + document.get("contents"));
        printStream.println();
    }
}

