/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.vector;

import simpack.api.impl.AbstractFeatureVectorSimilarityMeasure;
import simpack.exception.InvalidVectorSizeException;
import simpack.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdPearson
extends AbstractFeatureVectorSimilarityMeasure {
    public StdPearson() {
    }

    public StdPearson(Vector<? extends Number> vector, Vector<? extends Number> vector2) throws InvalidVectorSizeException {
        super(vector, vector2);
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        double d = this.v1.getMean();
        double d2 = this.v2.getMean();
        Vector<Double> vector = new Vector<Double>();
        Vector<Double> vector2 = new Vector<Double>();
        for (Number number : this.v1) {
            vector.add(number.doubleValue() - d);
        }
        for (Number number : this.v2) {
            vector2.add(number.doubleValue() - d2);
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        try {
            d3 = vector.getDotProduct(vector2);
            d4 = vector.getNorm(2.0);
            d5 = vector2.getNorm(2.0);
        }
        catch (InvalidVectorSizeException invalidVectorSizeException) {
            invalidVectorSizeException.printStackTrace();
        }
        this.similarity = d4 == 0.0 || d5 == 0.0 ? new Double(0.0) : new Double(d3 / (d4 * d5));
        this.similarity = 0.5 * (this.similarity + 1.0);
        this.setCalculated(true);
        return true;
    }
}

