/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.tree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ListIterator;
import javax.swing.tree.TreeNode;
import simpack.api.ITreeAccessor;
import simpack.api.ITreeNode;
import simpack.api.ITreeNodeComparator;
import simpack.api.impl.AbstractTreeSimilarityMeasure;
import simpack.exception.InvalidElementException;
import simpack.util.tree.TreeUtil;
import simpack.util.tree.comparator.TypedTreeNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopDownOrderedMaximumSubtree
extends AbstractTreeSimilarityMeasure {
    private ITreeNode tree1;
    private ITreeNode tree2;
    private HashMap<ITreeNode, ITreeNode> mappedTrees = new HashMap();
    private ITreeNode matchedTree1;
    private ITreeNode matchedTree2;
    private ITreeNode currentParent1;
    private ITreeNode currentParent2;

    public TopDownOrderedMaximumSubtree(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2) throws NullPointerException, InvalidElementException {
        this(iTreeAccessor, iTreeAccessor2, new TypedTreeNodeComparator());
    }

    public TopDownOrderedMaximumSubtree(ITreeAccessor iTreeAccessor, ITreeAccessor iTreeAccessor2, ITreeNodeComparator<ITreeNode> iTreeNodeComparator) throws NullPointerException, InvalidElementException {
        super(iTreeNodeComparator);
        if (iTreeAccessor == null || iTreeAccessor2 == null || iTreeAccessor.getRoot() == null || iTreeAccessor2.getRoot() == null) {
            throw new NullPointerException("Invalid accessors passed!");
        }
        this.tree1 = iTreeAccessor.getRoot();
        this.tree2 = iTreeAccessor2.getRoot();
    }

    @Override
    public boolean calculate() {
        this.setCalculated(false);
        if (this.mapOrderedCommonSubtree(this.tree1.getRoot(), this.tree2.getRoot())) {
            this.setCalculated(true);
            this.similarity = TreeUtil.getSimilarity1to1(this.getTree1(), this.getTree2(), this.getMatchedTree2());
            return true;
        }
        return false;
    }

    private boolean mapOrderedCommonSubtree(ITreeNode iTreeNode, ITreeNode iTreeNode2) {
        if (this.comparator.compare(iTreeNode, iTreeNode2) != 0) {
            return false;
        }
        this.mappedTrees.put(iTreeNode, iTreeNode2);
        ITreeNode iTreeNode3 = (ITreeNode)iTreeNode.clone();
        ITreeNode iTreeNode4 = (ITreeNode)iTreeNode2.clone();
        if (!iTreeNode.isRoot()) {
            this.currentParent1.add(iTreeNode3);
            this.currentParent1 = iTreeNode3;
        } else {
            this.matchedTree1 = this.currentParent1 = iTreeNode3;
        }
        if (!iTreeNode2.isRoot()) {
            this.currentParent2.add(iTreeNode4);
            this.currentParent2 = iTreeNode4;
        } else {
            this.matchedTree2 = this.currentParent2 = iTreeNode4;
        }
        if (!iTreeNode.isLeaf() && !iTreeNode2.isLeaf()) {
            Enumeration<? extends TreeNode> enumeration = iTreeNode.children();
            Enumeration<? extends TreeNode> enumeration2 = iTreeNode2.children();
            ArrayList<ITreeNode> arrayList = new ArrayList<ITreeNode>();
            while (enumeration.hasMoreElements()) {
                arrayList.add((ITreeNode)enumeration.nextElement());
            }
            ArrayList<ITreeNode> arrayList2 = new ArrayList<ITreeNode>();
            while (enumeration2.hasMoreElements()) {
                arrayList2.add((ITreeNode)enumeration2.nextElement());
            }
            ListIterator listIterator = arrayList.listIterator();
            ListIterator listIterator2 = arrayList2.listIterator();
            boolean bl = true;
            while (bl && listIterator.hasNext() && listIterator2.hasNext()) {
                ITreeNode iTreeNode5 = (ITreeNode)listIterator.next();
                ITreeNode iTreeNode6 = (ITreeNode)listIterator2.next();
                bl = this.mapOrderedCommonSubtree(iTreeNode5, iTreeNode6);
                this.currentParent1 = iTreeNode3;
                this.currentParent2 = iTreeNode4;
            }
        }
        return true;
    }

    public ITreeNode getTree1() {
        return this.tree1;
    }

    public ITreeNode getTree2() {
        return this.tree2;
    }

    public HashMap<ITreeNode, ITreeNode> getMappedTrees() {
        if (this.isCalculated()) {
            return this.mappedTrees;
        }
        return null;
    }

    public ITreeNode getMatchedTree1() {
        if (this.isCalculated()) {
            return this.matchedTree1;
        }
        return null;
    }

    public ITreeNode getMatchedTree2() {
        if (this.isCalculated()) {
            return this.matchedTree2;
        }
        return null;
    }
}

