/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.string;

import org.apache.log4j.Logger;
import simpack.api.ISequenceAccessor;
import simpack.api.impl.AbstractStringSimilarityMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jaro
extends AbstractStringSimilarityMeasure {
    public static Logger logger = Logger.getLogger(Jaro.class);

    public Jaro(ISequenceAccessor<String> iSequenceAccessor, ISequenceAccessor<String> iSequenceAccessor2) {
        super(iSequenceAccessor, iSequenceAccessor2);
    }

    @Override
    public boolean calculate() {
        String string = ((Object)this.accessor1).toString().toLowerCase();
        String string2 = ((Object)this.accessor2).toString().toLowerCase();
        int n = this.halfLengthOfShorter(string, string2);
        String string3 = this.commonChars(string, string2, n);
        String string4 = this.commonChars(string2, string, n);
        if (string3.length() != string4.length()) {
            logger.error((Object)("common1 != common2: '" + string3 + "' != '" + string4 + "'"));
            this.similarity = new Double(-1.0);
            this.setCalculated(true);
            return true;
        }
        if (string3.length() == 0 || string4.length() == 0) {
            this.similarity = new Double(0.0);
            this.setCalculated(true);
            return true;
        }
        int n2 = string3.length();
        int n3 = this.transpositions(string3, string4);
        double d = ((double)n2 / (double)string.length() + (double)n2 / (double)string2.length() + (double)(n2 - n3) / (double)n2) / 3.0;
        this.similarity = new Double(d);
        this.setCalculated(true);
        return true;
    }

    private int halfLengthOfShorter(String string, String string2) {
        return string.length() > string2.length() ? string2.length() / 2 + 1 : string.length() / 2 + 1;
    }

    private String commonChars(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = Math.max(0, i - n); !bl && j < Math.min(i + n, string2.length()); ++j) {
                if (stringBuffer2.charAt(j) != c) continue;
                bl = true;
                stringBuffer.append(c);
                stringBuffer2.setCharAt(j, '*');
            }
        }
        return stringBuffer.toString();
    }

    private int transpositions(String string, String string2) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            ++n;
        }
        return n /= 2;
    }
}

