/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.string;

import java.util.List;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.ISequenceAccessor;
import simpack.api.impl.AbstractStringSimilarityMeasure;
import simpack.exception.InvalidSimilarityMeasureNameException;
import simpack.measure.sequence.Levenshtein;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AveragedStringMatching
extends AbstractStringSimilarityMeasure {
    static Logger logger = Logger.getLogger(AveragedStringMatching.class);

    public AveragedStringMatching(ISequenceAccessor<String> iSequenceAccessor, ISequenceAccessor<String> iSequenceAccessor2) throws InvalidSimilarityMeasureNameException {
        super(iSequenceAccessor, iSequenceAccessor2);
    }

    @Override
    public boolean calculate() {
        double d = 0.0;
        List list = this.accessor1.getSequence();
        for (String string : list) {
            double d2 = Double.NEGATIVE_INFINITY;
            List list2 = this.accessor2.getSequence();
            for (String string2 : list2) {
                Levenshtein<String> levenshtein = null;
                double d3 = 0.0;
                levenshtein = new Levenshtein<String>(new StringAccessor(string), new StringAccessor(string2));
                d3 = levenshtein.getSimilarity();
                logger.debug((Object)(string + " <-> " + string2 + " = " + d3));
                if (!(d3 >= d2)) continue;
                d2 = d3;
            }
            d += d2;
        }
        double d4 = d / (double)list.size();
        this.similarity = new Double(d4);
        this.setCalculated(true);
        return true;
    }
}

