/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.sequence;

import java.util.List;
import org.apache.log4j.Logger;
import simpack.accessor.string.StringAccessor;
import simpack.api.IDistanceConversion;
import simpack.api.ISequenceAccessor;
import simpack.measure.sequence.Levenshtein;
import simpack.util.conversion.WorstCaseDistanceConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOL<E>
extends Levenshtein<E> {
    private static final Logger logger = Logger.getLogger(LOL.class);
    public static double DEFAULT_INNER_TRESHOLD = 0.5;
    protected double innerThreshold = DEFAULT_WEIGHT_DELETE;

    public LOL(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, new WorstCaseDistanceConversion(), DEFAULT_INNER_TRESHOLD);
    }

    public LOL(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, double d) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, new WorstCaseDistanceConversion(), d);
    }

    public LOL(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, IDistanceConversion iDistanceConversion) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, iDistanceConversion, DEFAULT_INNER_TRESHOLD);
    }

    public LOL(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, IDistanceConversion iDistanceConversion, double d) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, iDistanceConversion, d);
    }

    public LOL(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, double d, double d2, double d3, double d4, IDistanceConversion iDistanceConversion, double d5) {
        super(iSequenceAccessor, iSequenceAccessor2, d, d2, d3, d4, iDistanceConversion);
        this.innerThreshold = d5;
    }

    @Override
    public boolean calculate() {
        double d;
        int n;
        int n2;
        this.setCalculated(false);
        List list = this.sequenceAccessor1.getSequence();
        List list2 = this.sequenceAccessor2.getSequence();
        double d2 = 0.0;
        double[][] dArray = new double[list.size() + 1][list2.size() + 1];
        for (n2 = 0; n2 <= list.size(); ++n2) {
            dArray[n2][0] = n2;
        }
        for (n2 = 0; n2 <= list2.size(); ++n2) {
            dArray[0][n2] = n2;
        }
        for (n2 = 1; n2 <= list2.size(); ++n2) {
            for (n = 1; n <= list.size(); ++n) {
                String string;
                d = dArray[n][n2 - 1] + this.weightInsert;
                double d3 = dArray[n - 1][n2] + this.weightDelete;
                double d4 = dArray[n - 1][n2 - 1];
                String string2 = (String)list.get(n - 1);
                Levenshtein<String> levenshtein = new Levenshtein<String>(new StringAccessor(string2), new StringAccessor(string = (String)list2.get(n2 - 1)), this.weightInsert, this.weightDelete, this.weightReplace, this.weightReplaceEqual, this.conversion);
                double d5 = levenshtein.getSimilarity();
                d4 = d5 < this.innerThreshold ? (d4 += this.weightReplace) : (d4 += this.weightReplaceEqual);
                logger.debug((Object)("Comparing " + string2 + " " + string + " sim = " + d5));
                double d6 = Math.min(d, Math.min(d4, d3));
                logger.debug((Object)("Writing " + d6 + " for [" + string2 + "," + string + "]"));
                dArray[n][n2] = d6;
            }
        }
        if (logger.isDebugEnabled()) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                for (n = 0; n < dArray[0].length; ++n) {
                    System.out.print(dArray[n2][n] + " ");
                }
                System.out.println();
            }
        }
        double d7 = dArray[list.size()][list2.size()];
        d2 = this.calculateWorstCaseDistance(list, list2);
        logger.debug((Object)("wDist for " + list.toString() + " to " + list2.toString() + " is " + d2));
        if (this.conversion instanceof WorstCaseDistanceConversion) {
            ((WorstCaseDistanceConversion)this.conversion).setWorstCaseDistance(d2);
        }
        d = this.conversion.convert(d7);
        logger.debug((Object)("dist = " + d7 + ", wDist = " + d2 + ", sim = " + d));
        this.similarity = new Double(d);
        this.setCalculated(true);
        return true;
    }

    protected double calculateWorstCaseDistance(List<E> list, List<E> list2) {
        double d = list.size();
        double d2 = list2.size();
        double d3 = 0.0;
        if (d2 == d) {
            d3 = d * this.weightReplace;
        }
        if (d2 > d) {
            d3 = d * this.weightReplace;
            d3 += (d2 - d) * this.weightInsert;
        }
        if (d2 < d) {
            d3 = d2 * this.weightReplace;
            d3 += (d - d2) * this.weightDelete;
        }
        return d3;
    }
}

