/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.sequence;

import java.util.List;
import org.apache.log4j.Logger;
import simpack.api.IDistanceConversion;
import simpack.api.ISequenceAccessor;
import simpack.measure.sequence.Levenshtein;
import simpack.measure.weightingscheme.StringTFIDF;
import simpack.util.conversion.WorstCaseDistanceConversion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditDistanceTFIDF<E>
extends Levenshtein<E> {
    private static final Logger logger = Logger.getLogger(EditDistanceTFIDF.class);
    public static double DEFAULT_INNER_TRESHOLD = 0.5;
    protected double innerThreshold = DEFAULT_WEIGHT_DELETE;
    private StringTFIDF tfidf = null;

    public EditDistanceTFIDF(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, StringTFIDF stringTFIDF) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, new WorstCaseDistanceConversion(), DEFAULT_INNER_TRESHOLD, stringTFIDF);
    }

    public EditDistanceTFIDF(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, double d, StringTFIDF stringTFIDF) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, new WorstCaseDistanceConversion(), d, stringTFIDF);
    }

    public EditDistanceTFIDF(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, IDistanceConversion iDistanceConversion, StringTFIDF stringTFIDF) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, iDistanceConversion, DEFAULT_INNER_TRESHOLD, stringTFIDF);
    }

    public EditDistanceTFIDF(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, IDistanceConversion iDistanceConversion, double d, StringTFIDF stringTFIDF) {
        this(iSequenceAccessor, iSequenceAccessor2, DEFAULT_WEIGHT_INSERT, DEFAULT_WEIGHT_DELETE, DEFAULT_WEIGHT_REPLACE, DEFAULT_WEIGHT_REPLACE_EQUAL, iDistanceConversion, d, stringTFIDF);
    }

    public EditDistanceTFIDF(ISequenceAccessor<E> iSequenceAccessor, ISequenceAccessor<E> iSequenceAccessor2, double d, double d2, double d3, double d4, IDistanceConversion iDistanceConversion, double d5, StringTFIDF stringTFIDF) {
        super(iSequenceAccessor, iSequenceAccessor2, d, d2, d3, d4, iDistanceConversion);
        this.tfidf = stringTFIDF;
        this.innerThreshold = d5;
    }

    @Override
    public boolean calculate() {
        double d;
        int n;
        int n2;
        this.setCalculated(false);
        List list = this.sequenceAccessor1.getSequence();
        List list2 = this.sequenceAccessor2.getSequence();
        double d2 = 0.0;
        double[][] dArray = new double[list.size() + 1][list2.size() + 1];
        for (n2 = 0; n2 <= list.size(); ++n2) {
            dArray[n2][0] = n2;
        }
        for (n2 = 0; n2 <= list2.size(); ++n2) {
            dArray[0][n2] = n2;
        }
        for (n2 = 1; n2 <= list2.size(); ++n2) {
            for (n = 1; n <= list.size(); ++n) {
                d = dArray[n][n2 - 1] + this.weightInsert;
                double d3 = dArray[n - 1][n2] + this.weightDelete;
                double d4 = dArray[n - 1][n2 - 1];
                String string = (String)list.get(n - 1);
                String string2 = (String)list2.get(n2 - 1);
                logger.debug((Object)("Comparing " + string + " " + string2));
                d4 = this.tfidf.getSimilarity(string, string2) < this.innerThreshold ? (d4 += this.weightReplace) : (d4 += this.weightReplaceEqual);
                double d5 = Math.min(d, Math.min(d4, d3));
                logger.debug((Object)("Writing " + d5 + " for [" + string + "," + string2 + "]"));
                dArray[n][n2] = d5;
            }
        }
        if (logger.isDebugEnabled()) {
            for (n2 = 0; n2 < dArray.length; ++n2) {
                for (n = 0; n < dArray[0].length; ++n) {
                    System.out.print(dArray[n2][n] + " ");
                }
                System.out.println();
            }
        }
        double d6 = dArray[list.size()][list2.size()];
        d2 = this.calculateWorstCaseDistance(list, list2);
        logger.debug((Object)("wDist for " + list.toString() + "\n" + list2.toString() + " is " + d2));
        if (this.conversion instanceof WorstCaseDistanceConversion) {
            ((WorstCaseDistanceConversion)this.conversion).setWorstCaseDistance(d2);
        }
        d = this.conversion.convert(d6);
        logger.debug((Object)("dist = " + d6 + ", wDist = " + d2 + ", sim = " + d));
        this.similarity = new Double(d);
        this.setCalculated(true);
        return true;
    }

    protected double calculateWorstCaseDistance(List<E> list, List<E> list2) {
        double d = list.size();
        double d2 = list2.size();
        double d3 = 0.0;
        if (d2 == d) {
            d3 = d * this.weightReplace;
        }
        if (d2 > d) {
            d3 = d * this.weightReplace;
            d3 += (d2 - d) * this.weightInsert;
        }
        if (d2 < d) {
            d3 = d2 * this.weightReplace;
            d3 += (d - d2) * this.weightDelete;
        }
        return d3;
    }
}

