/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.it;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.AbstractSimilarityMeasure;
import simpack.exception.InvalidElementException;

public class Lin
extends AbstractSimilarityMeasure {
    static Logger logger = Logger.getLogger(Lin.class);
    private double N;
    private double numCommons;
    private double numElemX;
    private double numElemY;
    private IGraphAccessor graphAccessor;
    private IGraphNode x;
    private IGraphNode y;

    public Lin(double d, double d2, double d3, double d4) {
        this.N = d;
        this.numCommons = d2;
        this.numElemX = d3;
        this.numElemY = d4;
    }

    public Lin(IGraphAccessor iGraphAccessor, IGraphNode iGraphNode, IGraphNode iGraphNode2) throws InvalidElementException {
        this.graphAccessor = iGraphAccessor;
        this.x = iGraphNode;
        this.y = iGraphNode2;
        if (!iGraphAccessor.contains(iGraphNode)) {
            throw new InvalidElementException(((Object)iGraphNode).toString() + " not in set");
        }
        if (!iGraphAccessor.contains(iGraphNode2)) {
            throw new InvalidElementException(((Object)iGraphNode2).toString() + " not in set");
        }
    }

    public boolean calculate() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this.setCalculated(false);
        if (this.graphAccessor == null) {
            d3 = this.numCommons / this.N;
            d = this.numElemX / this.N;
            d2 = this.numElemY / this.N;
            this.similarity = new Double(2.0 * Math.log(d3) / (Math.log(d) + Math.log(d2)));
            this.setCalculated(true);
            return true;
        }
        try {
            double d4 = this.graphAccessor.size();
            int n = this.graphAccessor.getSuccessors(this.x, false).size() + 1;
            d = (double)n / new Double(d4);
            int n2 = this.graphAccessor.getSuccessors(this.y, false).size() + 1;
            d2 = (double)n2 / new Double(d4);
            IGraphNode iGraphNode = this.graphAccessor.getMostRecentCommonAncestor(this.x, this.y);
            int n3 = this.graphAccessor.getSuccessors(iGraphNode, false).size() + 1;
            d3 = (double)n3 / new Double(d4);
            this.similarity = d3 == 1.0 ? new Double(0.0) : new Double(2.0 * Math.log(d3) / (Math.log(d) + Math.log(d2)));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
            return false;
        }
    }
}

